	PRO read_calibration
;
;	reads in SIT tables etc., contains statements moved from old sit_common.pro
;
;		27-Jun-2008	/gm
;			15-Nov-2010 modify to handle new SIT-B lookup tables /gm
;			17-Mar-2011 + ...	modify to handle new SIT-A lookup tables /gm
;			11-Apr-2011	change delta_e's to nominal energy bin width differences /gm
;			12-Aug-2014	update efficiency filename to: sit_efficiencies_2014_08_12.txt /gm
;			24-Aug-2015	update efficiency filename to: sit_efficiencies_2015_08_24.txt /gm
;
	common sitcom
	common paths	
	common calibration
	common hex_tables
	common spacecraft
	common rate_information
	common background_correction
	common output_items
	common mbox_factors
	

;	********************************* list of calibration files to read in *******************************
	hex_table_file_name = 'sit_hex_tables_041811.dat'
	rate_boxes_file_name = 'sit_rate_box_ranges_041811_sav.dat'		
	efficiency_file_name = 'sit_efficiencies_2015_08_24.txt'	
;	************************************************************************************************


	; test if the elements have already been read in:
		restore_tables = 0   ; set restore tables = false
		if n_elements(amass_array) eq 0 then restore_tables = 1
	if restore_tables then BEGIN
;		print,'Reading in instrument calibration'
;		*********** don't read in the big tables unless they are being used 5/17/2011 **************
		if( pha_rates_out or pha_out or pha_spectra_out or histogram_out or multi_panel_out ) then begin
			restore,filename = calibration_data_path +'amass_sav.dat'
			restore,filename = calibration_data_path +'einc_ssd_sav.dat'
			restore,filename = calibration_data_path +'einc_tof_sav.dat'
		endif
		restore,filename = calibration_data_path +'energy_sav.dat'
		restore,filename = calibration_data_path +'tof_sav.dat'
;		print,'Instrument calibration read in'	

		calibration_files_date = strmid(tof_header_1,33)         ; get amass, etc. creation time from file header

;	*********************** list of previously used hex files ********************		
;		print, ' restoring hex file: ','sit_hex_tables_042806.dat'
;		print, ' restoring hex file: ','sit_hex_tables_030507.dat'
;		print, ' restoring hex file: ','sit_hex_tables_041107.dat'
;		print, ' restoring hex file: ','sit_hex_tables_082307.dat'
;		print, ' restoring hex file: ','sit_hex_tables_102910.dat'
;		print, ' restoring hex file: ','sit_hex_tables_041511.dat'
;	*************************************************************************

;		print, ' restoring hex file: ','hex_table_file_name'
		restore, filename=hex_table_path + hex_table_file_name
		hex_table_mjd = date2mjd(2015,08, 26)    ; store table date -- box check is only for data after date of current table LOAD
		
	ENDIF
	
	if restore_tables then BEGIN
;		print, rate_boxes_file_name, format="('Restoring: ',a)"
		restore,filename=sit_rate_box_ranges_path + rate_boxes_file_name
	ENDIF

; 	calculate the delta_e values:
	for iunit=0,1 do begin
	for irate=0,6 do delta_e(iunit,irate) = 1.
	for irate=7,115 do begin
		delta_e(iunit,irate) =  matrix_rates[irate].emax_nominal[iunit] - matrix_rates[irate].emin_nominal[iunit]                 ; 4/11/2011 /gm
		if( delta_e(iunit,irate) eq 0) then delta_e(iunit,irate) = -1.  ; since we later divide by delta_e, don't allow zero values
	endfor  ; iunit loop
	endfor  ; box number loop
	

	sit_efficiencies         ; read in the efficiencies

;	read in the background data if not yet done
	if(n_elements(bkgd_flux) eq 0.) then begin 
		bkgd_flux = fltarr(116,2)
		spillover_fraction = fltarr(116,2)
		spillover_box = intarr(116,2)
		box_width_adjust = fltarr(116,2)
		read_background_correction
;		print,'Background correction files read in'
	ENDIF

;	read in the rom_box corrections

;	print, 'restoring rom_box corrections file'
	restore, filename = sit_rom_box_corrections_path + 'sit_rom_box_corrections.sav'

	end
