	PRO read_background_correction
;
;	reads in SIT background correction files
;
;	10-Apr-2007	initial version /gm
;
;
common paths
common spacecraft
common background_correction

	for sc_id = 0,1 do begin
	
	infile = 	sit_background_corrections_path + 'SIT_'+ spacecraft_name(sc_id) + '_background_corr.txt'
	
;		print, ' opening: ', infile


	openr, lun_path, infile, /get_lun
	
	for i=1,7 do readf, lun_path, format='(/)'    ;  skip 7 header lines
	for i=0,115 do begin
		 readf, lun_path, flux, spillover, sourcebox, width
		 bkgd_flux(i,sc_id) = flux
		 spillover_fraction(i,sc_id) = spillover
		 spillover_box(i,sc_id) = sourcebox
		 box_width_adjust(i,sc_id) = width
	ENDFOR   ; file read loop

	free_lun, lun_path
	
	ENDFOR   ; spacecraft loop



;	print, 'background corrections read in'

	end
