PRO  PROCESS_RATES, packet, flag_rates, proc_flag
;
;	procedure to list SIT rates
;
;	gm	25-Aug-2006;  15-Mar-2007  move output file opening to open_outputs.pro
;		22-Mar-2010	add provision of webfiles processing
;
;

common lun_numbers
common output_items
common rate_information
common spacecraft
common time_bounds
common rate_averages
common pha_rate_averages
common webfiles

	if(proc_flag eq 4) then goto, writeout

;	flag = 0:  initialize
	
	IF(flag_rates eq 0) THEN BEGIN	
		flag_rates = 1   ; set flag to running value
		bin_last_rates=-1
	ENDIF

;	NOTE: time bins are calculated wrt a start time of midnight UT;  packets are added in until a bin boundary
;	is crossed (detected by a change in value of the variable bin_now_rates);  in which case the sums are
;	written out and then a new sum begun

	sit_rates, packet, sitratedata		;	pack the data into the structure sitratedata
;	print, ' process_rates:  sitratedata.header.timeCDS = ', sitratedata.header.timeCDS
;	print, ' process_rates:  saved value of utc_interval_start: ', utc_interval_start
;	if(n_elements(utc_interval_start_pha_rates)) then print, ' process_rates line 35:  saved value of utc_interval_start_pha_rates: ', utc_interval_start_pha_rates

;	process the SIT rate data structure here (if it is not empty)
	IF n_elements(sitratedata) ne 0 THEN BEGIN

	sitratedata_last = sitratedata           ; save last packet for use in write subroutine

; ********** if computing pha_spectra pass the priority 0 and 1 counts to the write_pha_spectra via common pha_rate_averages
	if(pha_spectra_out or pha_rates_out or (multi_panel_out gt 0)  ) then begin
		mpha_priority_rate_counts(0) += sitratedata.MRATES(0)
		mpha_priority_rate_counts(1) += sitratedata.MRATES(1)
	endif
	
; ********** if no rate or spectra processing, just return
	if( (rates_out eq 0) and (pha_rates_out eq 0) and (spectra_out eq 0) and (multi_panel_out eq 0) ) then return


	bin_now_rates = sitratedata.header.timeCDS.time/(avg_int_rates*60.*1000)
	bin_now_rates=floor(bin_now_rates)
	
;	if(bin_now_rates ne bin_last_rates) then print, ' process_rates:  ',proc_flag, bin_now_rates, bin_last_rates
	
;	NOTE: time bins are calculated wrt a start time of midnight UT;  

	bin_now_rates = sitratedata.header.timeCDS.time/(avg_int_rates*60.*1000)
	bin_now_rates=floor(bin_now_rates)
	
;	IF this is a first call of the program run or the day, just add in the rates   (bin_last_rates = -1 only at start of run or just after writeout, is set by clear rates/add rates)
	if( bin_last_rates eq -1 ) then begin
		add_rates, sitratedata
;	keep track of interval start if we're computing webfiles
		if( n_elements(webfiles_out) ne 0 ) then  begin
			utc_interval_start = sitratedata.header.timeCDS
			utc_interval_start_pha_rates = sitratedata.header.timeCDS
;			print, ' process_rates:  saved sitratedata.header.timeCDS: ', sitratedata.header.timeCDS
		endif
;	if the averaging interval is 1 min, then write out these rates		
			if( avg_int_rates eq 1 ) then begin
				proc_flag = 4
				if( rates_out ) then write_rates, sitratedata, proc_flag
				if (spectra_out) then WRITE_SPECTRA, sitratedata, proc_flag
				clear_rates
			endif
		return
	ENDIF
	
;	if we're in same time bin as before, just add in the rates and return
	IF( bin_now_rates eq bin_last_rates ) then begin
		add_rates, sitratedata
		return
	ENDIF
		
;	if we're crossed into a new bin, then write out the rates, clear, and start a new sum
	
	IF( (bin_now_rates ne bin_last_rates)  ) then begin
;		print, ' process rates calling write rates: ', rates_out, spectra_out
		proc_flag = 3        ; write to memory
		if( (rates_out gt 0) or (multi_panel_out gt 0) ) then write_rates, sitratedata, proc_flag
		if (spectra_out) then WRITE_SPECTRA, sitratedata, proc_flag
		clear_rates
		add_rates, sitratedata
;	keep track of interval start if we're computing webfiles
		if( n_elements(webfiles_out) ne 0 ) then  begin
;		for writing out pha rates, save the current interval start			
			utc_interval_start_pha_rates = utc_interval_start
;		print, ' process_rates line 98 saved value of utc_interval_start_pha_rates: ', utc_interval_start_pha_rates
			utc_interval_start = sitratedata.header.timeCDS
		endif
		return
	ENDIF

	ENDIF  ; for n_elements ne 0 loop
	

;		for proc_flag = 4, will write to disk

writeout:  if( (rates_out gt 0) or (multi_panel_out gt 0) ) then write_rates, sitratedata, proc_flag
		if (spectra_out) then WRITE_SPECTRA, sitratedata, proc_flag
		clear_rates
		
end
