PRO  process_pha, packet, apid, run_checks, histogram_num, proc_flag, pha_case

;
;	procedure to list SIT pha
;
;	gm	25-Aug-2006;  15-Mar-2007 move file opening to open_outputs.pro;  20 Mar-2007 remove time checks
;
;	Modification history:
;		22-Mar-2011	move pha_writes counter to actual write statements; change write limit to 999,900 /gm
;		11-Mar-2013	modify to just process pha packets, with time information coming from new routine
;					process_pha_times /gm
;		11-Aug-2014	add a test in case pha_case statement to handle pha_case undefined from routine process_pha_times /gm

common lun_numbers
common output_items
common spacecraft
common time_bounds
common box_check
common misc_counters
common paths
common pha_rate_averages
common rate_averages

	if(proc_flag eq 4) then goto, writeout

;	process next packet


	SIT_PHA, PACKET, SITPHADATA, num_pha, apid    ; pack the data into the structure sitphadata

;	********* note:  if no pha events, then sitphadata is not defined so just return ***********

	IF n_elements(sitphadata) ne 0 THEN BEGIN	

;	*******************************	

;	check the matrix boxes
	if run_checks then calc_box, spacecraft_id, sitphadata

;	***************** pha_case branching information passed from routine add_pha_times *******************
	if(  (pha_rates_out gt 0) or (multi_panel_out gt 0)  or pha_spectra_out ) then begin
		if( n_elements(pha_case) gt 0 ) then begin
	
			case pha_case of
	
				1:	add_pha_rates, sitphadata, apid
				2:	add_pha_rates, sitphadata, apid
				3:	add_pha_rates, sitphadata, apid
				4:	
		
			endcase
			
		endif		; end of test for pha_case defined
	endif    ; end of pha_case section if doing pha_rates or pha_spectra

;	*******************************

	if( histogram_out ) then add_hist_pha, sitphadata, histogram_num


writeout:   if( ((pha_out) and (pha_writes lt 999900.d0)) or (multi_panel_out gt 0))  then WRITE_PHA,  sitphadata, apid, proc_flag   ; write out the pha data
;		clear_PHA  - not implemented

	if( proc_flag eq 4 ) then begin	
		if( pha_spectra_out ) then WRITE_PHA_SPECTRA,  sitphadata, apid, proc_flag
		if( ( pha_rates_out gt 0) or (multi_panel_out gt 0) ) then begin
;			print, ' calling write pha rates from line 97 process_pha'
			WRITE_PHA_rates,  sitratedata_last, proc_flag
		endif
		clear_pha_rates
		clear_rates   ;  clear rates accumulators also 
	endif
	
	return

	ENDIF  ; for n_elements ne 0 loop	
	
	end
