PRO  PROCESS_HK, packet, flag, proc_flag, run_checks, hk_out
;
;	procedure to process SIT HK data
;
;	gm	12-Oct-2006;  15-Mar-2007  open output file moved to open_outputs.pro
;
;
;

common lun_numbers
common spacecraft
common time_bounds
common hk_averages
common current_packet_time

;	print, ' process_hk: num_avg_ints, proc_flag: ', num_avg_ints_hk, proc_flag

	if(proc_flag eq 4) then goto, writeout

;	flag = 0:  initialize
	
	IF(flag eq 0) THEN BEGIN	
		flag = 1   ; set flag to running value

	ENDIF


;	flag = 1:  process next packet

;	NOTE: time bins are calculated wrt a start time of midnight UT;  packets are added in until a bin boundary
;	is crossed (detected by a change in value of the variable bin_now_rates);  in which case the sums are
;	written out and then a new sum begun

	sit_hk, packet, sithkdata		;	pack the date into the structure sithkdata

; process the SIT hk data structure here (if it is not empty)
	IF n_elements(sithkdata) ne 0 THEN BEGIN
;	if the SIT hk data is zero (ie instr not turned on) then skip this packet;  do test using tof_gain
	if(sithkdata.tof_gain eq 0) then return

;	check that the flight software version and lookup table checksums are correct -- put back in 2/13/08 /gm
	if( run_checks ) then  check_sw_lookup, sithkdata, current_mjd


	bin_now_hk = sithkdata.header.timeCDS.time/(avg_int_hk*60.*1000)
	bin_now_hk=floor(bin_now_hk)

;	IF this is a first call after clearing accumulators, just add in the hk
	if( bin_last_hk eq -1 ) then begin
		add_hk, sithkdata
		return
	ENDIF
	
;	if we're in same time bin as before, just add in the hk and return
	IF( (bin_now_hk eq bin_last_hk) and (bin_last_hk ge 0) ) then begin
		add_hk, sithkdata
		return
	ENDIF
		
;	if we're crossed into a new bin, then write out the hk, clear, and start a new sum

	IF( ((bin_now_hk ne bin_last_hk) and (bin_last_hk ge 0))  ) then begin
;		print, ' process hk calling write hk: ', hk_out, spectra_out
		proc_flag = 3        ; write to memory
		if( hk_out ) then WRITE_hk,  sithkdata, proc_flag
		clear_hk
		add_hk, sithkdata
		return
	ENDIF

	ENDIF  ; for n_elements ne 0 loop
	

;		for proc_flag = 4, will write to disk

writeout:  	if( hk_out ) then WRITE_hk,  sithkdata, proc_flag
		clear_hk
		
end
