PRO  PROCESS_BEACON, packet, flag, proc_flag
;
;	procedure to list SIT rates
;
;	gm	13-Oct-2006;  15-Mar-2007  output file opening moved to open_outputs section
;
;
;

common lun_numbers
common rate_information
common spacecraft
common time_bounds
common beacon_averages

	if(proc_flag eq 4) then goto, writeout

;	flag = 0:  initialize counters
	
	IF(flag eq 0) THEN BEGIN	
		flag = 1   ; set flag to running value

		bin_last_beacon=-1
		flag = 1 ;  now process this data		
	ENDIF



;	flag = 1:  process next packet

;	NOTE: time bins are calculated wrt a start time of midnight UT;  packets are added in until a bin boundary
;	is crossed (detected by a change in value of the variable bin_now_rates);  in which case the sums are
;	written out and then a new sum begun

	sep_beacon, packet, sepbeacondata		;	pack the data into the structure sepbeacondata

	; process the SIT beacon data structure here (if it is not empty)
	IF n_elements(sepbeacondata) ne 0 THEN BEGIN


	bin_now_beacon = sepbeacondata.header.timeCDS.time/(avg_int_beacon*60.*1000)
	bin_now_beacon=floor(bin_now_beacon)

;	IF this is a first call after clearing accumulators, just add in the beacon
	if( bin_last_beacon eq -1 ) then begin
		add_beacon, sepbeacondata
		return
	ENDIF
	
;	if we're in same time bin as before, just add in the beacon and return
	IF( (bin_now_beacon eq bin_last_beacon) and (bin_last_beacon ge 0) ) then begin
		add_beacon, sepbeacondata
		return
	ENDIF
		
;	if we're crossed into a new bin, then write out the beacon, clear, and start a new sum

	IF( ((bin_now_beacon ne bin_last_beacon) and (bin_last_beacon ge 0))  ) then begin
;		print, ' process beacon calling write beacon: ', beacon_out, spectra_out
		proc_flag = 3        ; write to memory
		WRITE_BEACON,  sepbeacondata, proc_flag
		clear_beacon
		add_beacon, sepbeacondata
		return
	ENDIF

	ENDIF  ; for n_elements ne 0 loop
	

;		for proc_flag = 4, will write to disk

writeout:  	WRITE_BEACON,  sepbeacondata, proc_flag
		clear_beacon
		
end