PRO	packet_checksum, packet
;
;	17-Oct-2006	gm
;
;	computes IMPACT packet checksum
;		no action if packet sum mod 256 = 0 (checksum passed)
;		prints out error warning of checksum test not passed
;
common lun_numbers
common output_items

;
	total_data = ulong(total(packet.dat))
;	now put together the totals from the packet header structure (see procedure read_stereo_pkt.pro)
	
	header_sum=bytarr(11)
	
	header_sum(0) = ishft(packet.pkt.hdr,-8)
	header_sum(1) = packet.pkt.hdr mod 256
	header_sum(2) = ishft(packet.pkt.grp,-8)
	header_sum(3) = packet.pkt.grp mod 256
	header_sum(4) = ishft(packet.pkt.size,-8)
	header_sum(5) = packet.pkt.size mod 256
	
;	section of ulong variable	
	temp = ulong(packet.pkt.seconds)
	header_sum(6) = ishft(temp,-24)
	temp = temp - ulong(header_sum(6)*256*256*256)
	header_sum(7) = ishft(temp,-16)
	temp = temp - ulong(header_sum(6)*256*256)
	header_sum(8) = ishft(temp,-8)
	header_sum(9) = temp mod 256

	header_sum(10)=packet.pkt.subsec
	
;	printf, lun_print, header_sum
	
	total = total(header_sum) + total_data
;	printf, lun_print, total(header_sum), total_data, total, total mod 256
	if((total mod 256) ne 0) then printf, lun_print, ' Packet checksum error!'
	return
	end


;	pkt structure from read_stereo_pkt.pro	
;	PKT = {HDR:	0U,	$
;       GRP:     0U,     $
;       SIZE:	0U,	$
;       SECONDS:	0UL,	$
;       SUBSEC:	0B}