PRO  open_outputs
;
;	procedure to open SIT lister files
;
;	gm	15-Mar-2007;  adapted from Aug 2006 routines
;
;
;

common lun_numbers
common rate_information
common spacecraft
common time_bounds
common rate_averages
common pha_limits
common histogram_sums
common output_items
common mbox_factors
common background_correction

;	save output file name for final message call from sit_lister
	out_file = make_lister_filename('xxx')
;	get system time for headers
	current_time=systime()
	if( ( bkgd_correction_on eq 1) and (type_out le 1) ) then correction='on' else correction='off'

; ****************************** batch listing **************************

	
	IF(batch_out) THEN BEGIN	
		
		openw, lun_print, make_lister_filename('batch'), /get_lun
;		printf, lun_print, ' opening batch output file, unit = ', lun_print
;	write the output header:
		printf, lun_print, spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a8," batch output listing --- run time: ",a0)'
		print_cal_files, lun_print
		printf, lun_print, ' '

	ENDIF



; ************************** RATES *************************
	
	IF(rates_out) THEN BEGIN	

		openw, lun_ratelist, make_lister_filename('rates'), /get_lun
;		printf, lun_print, ' opening rates output file, unit = ', lun_ratelist
;	write the output header:
		printf, lun_ratelist,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a8," count rates --- run time: ",a0)'
		printf, lun_ratelist,  12 + number_times + 2*total(swoosh_flag), format='(" Number of header lines:",i4)'
		print_units, lun_ratelist
		print_cal_files, lun_ratelist
		printf, lun_ratelist, ' '
		print_intervals, lun_ratelist
		printf, lun_ratelist,format='($," Time,year,day of year,delta t/2,")'
		printf, lun_ratelist, disc_names, format='($,8(a,","))'
		for i=0,6 do printf, lun_ratelist, matrix_rates[i].mat_names(spacecraft_id),  $
			format='($,(a,","))'
		for i=7,115 do if(effic(spacecraft_id,i) gt 0.) then printf, lun_ratelist, matrix_rates[i].mat_names(spacecraft_id), (matrix_rates[i].emin_nominal(spacecraft_id) + matrix_rates[i].emax_nominal(spacecraft_id))/2., $
			format='($,(a,f7.3," MeV/n,"))'
		printf, lun_ratelist,format='($,"sum MR 1+2,sum MR 3+4,sum MR 7-116,hv step,TOFERROR enable + 2,HV enable + 4,EONLY enable + 6,JUNK enable + 8,LIMHI,")'
		printf, lun_ratelist,format='($,"time rotated to Earth-Sun line,year rotated to Earth-Sun line,day rotated to Earth-Sun line,GSE-X (AU),GSE-Y (AU),GSE-Z (AU),Earth - Sun - STEREO-A (deg),Earth - Sun - STEREO-B (deg),STEREO-B - Sun - STEREO-A (deg),")'
;		write out a character to force a line feed
		printf, lun_ratelist,' ',format='(a1)'

	
	ENDIF

; ***************** BEACON ************************

	IF((beacon_out) and (multi_panel_out_sit_a_conjunction eq 0)) THEN BEGIN	
		openw, lun_beaconlist, make_lister_filename('bea'), /get_lun
;		printf, lun_print, ' opening beacon output file, unit = ', lun_beaconlist
;	write the output header:
		printf, lun_beaconlist,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a8," beacon intensities --- run time: ",a0)'
		printf, lun_beaconlist,  7 + number_times, format='(" Number of header lines:",i4)'
		printf, lun_beaconlist,format='(/," units:  intensity (particles/s cm2 sr MeV/nucleon)",/)'
		print_intervals, lun_beaconlist
		printf, lun_beaconlist,format='($," Time,year,day of year,delta t/2,")'

;		numbered beacon list
;		for i=0,60 do printf, lun_beaconlist, i, format='($,("beacon rate ",i2,","))'
;		printf, lun_beaconlist,' ',format='(a1)'
		
;		named beacon list
			;HETflux = { $  (rate names from Andrew Davis's routine sep_beacon.pro)
		printf, lun_beaconlist,format='($," HET Electrons, HET Protons1, HET Protons2, HET Protons3, HET He1, HET He2, HET He3, HET CNO1, HET CNO2, HET Fe,")'
			;SITflux = { $
		printf, lun_beaconlist,format='($,"SIT He1,SIT He2,SIT He3,SIT He4,SIT CNO1,SIT CNO2,SIT CNO3,SIT CNO4,SIT Fe1,SIT Fe2,SIT Fe3,SIT Fe4,")'
			;LETflux = { $
		printf, lun_beaconlist,format='($,"LET Protons1,LET Protons2A,LET Protons2B,LET Protons3,LET He4_1,LET He4_2A,LET He4_2B,LET He4_3A,LET He4_3B,LET He3_1,LET He3_2,LET CNO1,LET CNO2,LET CNO3,LET Fe1,LET Fe2,LET Fe3,LET Fe4,")'
			;SEPTflux = { $
		printf, lun_beaconlist,format='($,"Electrons0N_1,Electrons2N_1,Electrons0E_1,Electrons2E_1,ElectronsSum_2,ElectronsSum_3,Electrons0N_4,Electrons2N_4,Electrons0E_4,Electrons2E_4,Ions1N_1,Ions3N_1,Ions1E_1,Ions3E_1,IonsSum_2,IonsSum_3,Ions1N_4,Ions3N_4,Ions1E_4,Ions3E_4,")'
		printf, lun_beaconlist,format='($,"time rotated to Earth-Sun line,year rotated to Earth-Sun line,day rotated to Earth-Sun line,GSE-X (AU),GSE-Y (AU),GSE-Z (AU),Earth - Sun - STEREO-A (deg),Earth - Sun - STEREO-B (deg),STEREO-B - Sun - STEREO-A (deg),")'
		printf, lun_beaconlist,' ',format='(a1)'
		
	ENDIF

; ************************* PHA ***********************
	
	IF(pha_out)THEN BEGIN	
	
		openw, lun_phalist, make_lister_filename('pha'), /get_lun
;		printf, lun_print, ' opening pha output file, unit = ', lun_phalist
;	write the output header:
		printf, lun_phalist,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a8," pha data --- run time: ",a0)'
		printf, lun_phalist,  12 + number_times + 2*total(swoosh_flag), format='(" Number of header lines:",i4)'
		printf, lun_phalist, ' '
		print_cal_files, lun_phalist
		printf, lun_phalist,' '
		printf, lun_phalist,  pha_mlo, pha_mhi, pha_elo,  pha_ehi, $
		       format='(" PHA limits:  mass between ",f6.2," and ",f6.2," AMU, energy between ",f7.3," and ",f9.3," MeV/nucleon",/)'
		print_intervals, lun_phalist
		printf, lun_phalist,format='($," Time,year,day of year,Mass (AMU),Einc ssd (MeV/nuc),Einc tof (MeV/nuc),Tof (ns),Energy (MeV),T ch,E ch,gain,priority,tof flg1,tof flg2,tof error proc,Matrix box,apid,Calc Matrix box, Calc Pri,Calc Bea box, M box err, Pri err,")'
		printf, lun_phalist,format='($,"time rotated to Earth-Sun line,year rotated to Earth-Sun line,day rotated to Earth-Sun line,GSE-X (AU),GSE-Y (AU),GSE-Z (AU),Earth - Sun - STEREO-A (deg),Earth - Sun - STEREO-B (deg),STEREO-B - Sun - STEREO-A (deg),")'			
		printf, lun_phalist,' ',format='(a1)'
		
		
	ENDIF
; ******************************* HK ******************************

	IF(hk_out) THEN BEGIN	
	
		openw, lun_hklist, make_lister_filename('hk'), /get_lun
;		printf, lun_print, ' opening hk output file, unit = ', lun_hklist
;	write the output header:
		printf, lun_hklist,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a8," housekeeping data --- run time: ",a0)'
		printf, lun_hklist,  5 + number_times, format='(" Number of header lines:",i4)'
		printf, lun_hklist,' ',format='(a1)'
		print_intervals, lun_hklist
		printf, lun_hklist,format='(" Time,year,day of year,delta t/2,MF number,tof gain,tof cal offset x -1,tof cal error,HV monitor,dtof temp,foil temp,ssd temp,3.3V monitor,2.5V monitor,5.0V monitor,6.0V monitor,software_version,lookup_checksum,")'

	ENDIF

; ****************************** SPECTRA************************
	
	IF(spectra_out) THEN BEGIN	
		

		openw, lun_spectralist, make_lister_filename('spectra'), /get_lun
;		printf, lun_print, ' opening spectra output file, unit = ', lun_spectralist
;	write the output header:
		printf, lun_spectralist,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a8," spectra and ratios --- run time: ",a0)'
		printf, lun_spectralist,  12 + number_times + 2*total(swoosh_flag), correction, format='(" Number of header lines:",i4, "   background correction: ",a0)'
		print_units, lun_spectralist
		print_cal_files, lun_spectralist
		printf, lun_spectralist, ' '
		print_intervals, lun_spectralist
		printf, lun_spectralist,format='(" Event,Time,year,day of year,Elo,Ehi,MeV/nuc,Delta E/2,H,sigma,3He,sigma,4He,sigma,C,sigma,O,sigma,NeS,sigma,Fe,sigma,UH,sigma,H/He,sigma,3He/4He,sigma,He/O,sigma,C/O,sigma,NeS/O,sigma,Fe/O,sigma")'



	ENDIF

; ****************************** histogram************************
	
	IF(histogram_out) THEN BEGIN	

		
		openw, lun_histogramlist, make_lister_filename('histogram'), /get_lun
;		printf, lun_print, ' opening histogram output file, unit = ', lun_histogramlist
;	write the output header:
		printf, lun_histogramlist,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a8," mass histogram --- run time: ",a0)'
		printf, lun_histogramlist,  14 + number_times + 2*total(swoosh_flag), format='(" Number of header lines:",i4)'
		printf, lun_histogramlist,  pha_mlo, pha_mhi, pha_elo,  pha_ehi, $
		       format='(/," PHA limits:  mass between ",f6.2," and ",f6.2," AMU, energy between ",f7.3," and ",f9.3," MeV/nucleon",/)'
		printf, lun_histogramlist, bin_width, format='(" Histogram bin width: ",f6.2," AMU",/)'
		print_cal_files, lun_histogramlist
		printf, lun_histogramlist, ' '
		print_intervals, lun_histogramlist
		hist_times = time_data
		hist_times.(0)(0:4,0) = time_data.(0)(0:4,0)
		num_histograms = 1
		for i = 0, (number_times-1) do begin
		
			if(time_data.(0)(10,i) eq 2) then begin
				hist_times.(0)(5:9,num_histograms-1) = time_data.(0)(5:9,i)
				num_histograms = num_histograms + 1
				hist_times.(0)(0:4,num_histograms-1) = time_data.(0)(0:4,i+1)
			endif
			if( time_data.(0)(10,i) eq 3) then hist_times.(0)(5:9,num_histograms-1) = time_data.(0)(5:9,i)

			if( time_data.(0)(10,i) eq 3) then break	
		endfor
		
;		for i = 0, (num_histograms-1) do printf, lun_print, i, hist_times.(0)(*,i)
		
		printf, lun_histogramlist, format='($,"Bin (AMU),")'
		for i = 0, (num_histograms-1) do begin 
			printf, lun_histogramlist,  i + 1, $
			hist_times.(0)(1,i), 	hist_times.(0)(2,i),	hist_times.(0)(0,i),	hist_times.(0)(3,i),	hist_times.(0)(4,i), $
			hist_times.(0)(6,i), 	hist_times.(0)(7,i),	hist_times.(0)(5,i),	hist_times.(0)(8,i),	hist_times.(0)(9,i), $
			format='($,"Event",i4,2x,i2,"/",i0,"/",i4,2x,i02,":",i02," to ", i2,"/",i0,"/",i4,2x,i02,":",i02)'
;		to indicate an swoosh interval for the time header, add an "S" at the end of the time list
			if(swoosh_flag(i)) then printf, lun_histogramlist, format='($," S,")' else printf, lun_histogramlist, format='($,",")'
		ENDFOR	
			
;		print out a space to force a line feed		
		printf, lun_histogramlist,' ',format='(a1)'
		
;		now set up the array to hold the histograms
		nbins = (pha_mhi-pha_mlo)/bin_width
		histogram_array = ulonarr(num_histograms,nbins)
		


	ENDIF
	
	
	
; ****************************** pha_spectra************************
	
	IF(pha_spectra_out) THEN BEGIN	
		
		openw, lun_pha_spectralist, make_lister_filename('pha_spectra'), /get_lun
;		printf, lun_print, ' opening pha_spectra output file, unit = ', lun_pha_spectralist
;	write the output header:
		printf, lun_pha_spectralist,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a8," pha_spectra and ratios --- run time: ",a0)'
		printf, lun_pha_spectralist,  12 + number_times + 2*total(swoosh_flag), correction, format='(" Number of header lines:",i4, "   background correction: ",a0)'
		print_units, lun_pha_spectralist
		print_cal_files, lun_pha_spectralist
		printf, lun_pha_spectralist, ' '
		print_intervals, lun_pha_spectralist
		printf, lun_pha_spectralist,format='(" Event,Time,year,day of year,Elo,Ehi,MeV/nuc,Delta E/2,H,sigma,3He,sigma,4He,sigma,C,sigma,O,sigma,NeS,sigma,Fe,sigma,UH,sigma,H/He,sigma,3He/4He,sigma,He/O,sigma,C/O,sigma,NeS/O,sigma,Fe/O,sigma")'



	ENDIF

; ************************** PHA RATES *************************
	
	IF(pha_rates_out) THEN BEGIN	

		openw, lun_pha_ratelist, make_lister_filename('pha_rates'), /get_lun
;		printf, lun_print, ' opening pha rates output file, unit = ', lun_pha_ratelist
;	write the output header:
		printf, lun_pha_ratelist,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a8," pha derived count rates --- run time: ",a0)'
		printf, lun_pha_ratelist,  12 + number_times + 2*total(swoosh_flag), format='(" Number of header lines:",i4)'
		print_units, lun_pha_ratelist
		print_cal_files, lun_pha_ratelist
		printf, lun_pha_ratelist, ' '
		print_intervals, lun_pha_ratelist
		printf, lun_pha_ratelist,format='($," Time,year,day of year,delta t/2,")'
		printf, lun_pha_ratelist, disc_names, format='($,8(a,","))'
		for i=0,6 do printf, lun_pha_ratelist, matrix_rates[i].mat_names(spacecraft_id),  $
			format='($,(a,","))'
		for i=7,115 do if(effic(spacecraft_id,i) gt 0.) then printf, lun_pha_ratelist, matrix_rates[i].mat_names(spacecraft_id), (matrix_rates[i].emin_nominal(spacecraft_id) + matrix_rates[i].emax_nominal(spacecraft_id))/2., $
			format='($,(a,f7.3," MeV/n,"))'
		printf, lun_pha_ratelist,format='($,"sum MR 1+2,sum MR 3+4,sum MR 7-116,hv step,TOFERROR enable + 2,HV enable + 4,EONLY enable + 6,JUNK enable + 8,LIMHI,")'
		printf, lun_pha_ratelist,format='($,"time rotated to Earth-Sun line,year rotated to Earth-Sun line,day rotated to Earth-Sun line,GSE-X (AU),GSE-Y (AU),GSE-Z (AU),Earth - Sun - STEREO-A (deg),Earth - Sun - STEREO-B (deg),STEREO-B - Sun - STEREO-A (deg),")'
;		write out a character to force a line feed
		printf, lun_pha_ratelist,' ',format='(a1)'

	
	ENDIF
	

end
