FUNCTION one_ov_v_to_energy, one_ov_v
;
;	returns energy per nucleon given 1/v in AU/hr
;
;		3-Apr-2007	/gm
;	
;	trap very low values of 1/v, and just return 1000 MeV/n for those cases (1/v = 0.1587 hr/AU)
		if(one_ov_v lt 0.1587) then return, 1000.
;	convert AU/hr to v/c
		v_conv = 1./one_ov_v
		v_conv = v_conv*(1.496e8/3600.)/2.998e5
		part = sqrt(1.-v_conv^2)
		
		return, 936.*((1/part)-1)

end