PRO  multi_panel_outputs, current_mjd
;
;	procedure to open SIT lister multi-panel plot files
;
;	gm	16-Apr-2007;  adapted from open_outputs
;		11-Mar-2010; change PHA mass panel to ranges to improve plot appearance:
;			mass < 8, 250-900 keV/n
;			mass > 8, 80-150 keV/n
;			change count rate panel to go to lower energies
;	2014-Jul-21		write out a single empty data line at the start of each file to permit
;					output of empty plot frames for periods when there is no data
;					implemented for periods of long data loss during solar conjunctions /gm
;	13-Nov-2018		add flag to rate output file for pha rates being used after 9/23/2018 /gm
;
;

common lun_numbers
common output_items
common spacecraft
common time_bounds
common rate_information
common multi_panel_plot_items



; **************** first call:  set up start/stop times and open files ****************
	if( flag_multi_panel eq 0 ) then begin
		flag_multi_panel = 1
		multi_panel_start_mjd = floor(start_MJD)
		multi_panel_stop_mjd = multi_panel_start_mjd + multi_panel_out
;		save output file name for final message call from sit_lister
		out_file = make_multi_panel_filename('xxx')
		goto, openfiles
	ENDIF

	
; ***************** subsequent calls, check to see if we are at end of interval, if not, return **********
	if( current_mjd lt multi_panel_stop_mjd ) then return
	
; ***** at end of interval, so close files, calculate new start/stop dates, and open new files
	free_lun,  lun_multi_rate, lun_multi_mass, lun_multi_smoosh
		multi_panel_start_mjd = multi_panel_start_mjd  + multi_panel_out
		multi_panel_stop_mjd = multi_panel_stop_mjd + multi_panel_out
		print, ' current start, stop: ', multi_panel_start_mjd , multi_panel_stop_mjd 


; ************************** RATES *************************
;	get system time for headers
openfiles:	current_time=systime()

	openw, lun_multi_rate, make_multi_panel_filename('multi_panel_rates'), /get_lun
;		print, ' opening multi-panel rates output file, unit = ', lun_multi_rate
;	write the output header:
		printf, lun_multi_rate,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a0," count rates for multi panel plots --- run time: ",a0)'
		ratebox_source = 'matrix rates'
		if( current_mjd ge 58385.d0 ) then ratebox_source ='pha rates'
		printf, lun_multi_rate,  7, multi_panel_out, ratebox_source, format='(" Number of header lines:",i4, 6x,"Plot length is ",i3," days; rates calculated from: ",a)
		printf, lun_multi_rate,' ',format='(a1)'
		print_multi_panel_intervals, lun_multi_rate, multi_panel_start_mjd, multi_panel_stop_mjd
		printf, lun_multi_rate,format='($," Time,year,day of year,delta t/2,")'

		if( multi_panel_out_sit_a_conjunction eq 0 ) then begin
			for i=0, 3 do printf, lun_multi_rate, matrix_rates[multi_panel_rates(i)].mat_names(spacecraft_id), (matrix_rates[multi_panel_rates(i)].emin_nominal(spacecraft_id) + matrix_rates[multi_panel_rates(i)].emax_nominal(spacecraft_id))/2., $
				format='($,(a,f7.3," MeV/n,"))'
;				write out a character to force a line feed
				printf, lun_multi_rate,' ',format='(a1)'
		endif else begin
			printf, lun_multi_rate, ' xxxx ,4He Beacon*1.8 0.240 MeV/n,CNO Beacon*1.2 0.240 MeV/n,Fe Beacon*1.75 0.240 MeV/n,'
		endelse

;		printf, lun_multi_rate,format='($,"time rotated to Earth-Sun line,year rotated to Earth-Sun line,day rotated to Earth-Sun line,GSE-X (AU),GSE-Y (AU),GSE-Z (AU),Earth - Sun - STEREO-A (deg),Earth - Sun - STEREO-B (deg),STEREO-B - Sun - STEREO-A (deg),")'


;	*********** 2014-07-21
		timeheader = { mjd:0l, time: 0l}
		timeheader.mjd = multi_panel_start_mjd
		timeheader.time = 0l
		mjd2date,multi_panel_start_mjd,yr_header,mo_header,da_header
;				rates        2014/07/11 10:46:40,     2014.524518,      192.449074,   810.0,  0.0000e+00,  0.0000e+00,  0.0000e+00,  0.0000e+00,		
		printf, lun_multi_rate, yr_header,mo_header,da_header, mjd2decyr(timeheader), mjd2decdoy(timeheader),  format="(i5,'/',i2.2,'/',i2.2,' 00:00:00,',2(f16.6,','),' 10.0,  0.0000e+00,  0.0000e+00,  0.0000e+00,  0.0000e+00,')"



; ************************* PHA_MASS ***********************

	
		openw, lun_multi_mass, make_multi_panel_filename('multi_panel_pha'), /get_lun
;		print, ' opening multi-panel pha output file, unit = ', lun_multi_mass
;	write the output header:
		printf, lun_multi_mass,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a0," pha data for multi panel plots --- run time: ",a0)'
		printf, lun_multi_mass,  9, multi_panel_out, format='(" Number of header lines:",i4, 6x,"Plot length is ",i3," days")'
		printf, lun_multi_mass,' ',format='(a1)'
		printf, lun_multi_mass,  8., 0.250, 0.9, 8., 0.08, 0.15, $
		       format='(" PHA limits:  mass < ",f6.2," AMU, energy:  ",f7.3," and ",f7.3," MeV/nucleon ; mass > ",f6.2," AMU, energy:  ",f7.3," and ",f7.3," MeV/nucleon",/)'
		print_multi_panel_intervals, lun_multi_mass, multi_panel_start_mjd, multi_panel_stop_mjd
		printf, lun_multi_mass,format='($," Time,year,day of year,delta t/2,Mass (AMU),")'
;		printf, lun_multi_mass,format='($,"time rotated to Earth-Sun line,year rotated to Earth-Sun line,day rotated to Earth-Sun line,GSE-X (AU),GSE-Y (AU),GSE-Z (AU),Earth - Sun - STEREO-A (deg),Earth - Sun - STEREO-B (deg),STEREO-B - Sun - STEREO-A (deg),")'			
		printf, lun_multi_mass,' ',format='(a1)'

;	*************** 2014-07-21
;				pha       2014/07/14 13:16:39,     2014.533023,      195.553223, 0.,  5.3837e+01,
		printf, lun_multi_mass, yr_header,mo_header,da_header, mjd2decyr(timeheader), mjd2decdoy(timeheader),  format="(i5,'/',i2.2,'/',i2.2,' 00:00:00,',2(f16.6,','),' 0.0,  0.0000e+00,')"



; ************************* PHA_SMOOSH ***********************

	
		openw, lun_multi_smoosh, make_multi_panel_filename('multi_panel_smoosh'), /get_lun
;		print, ' opening multi-panel smoosh output file, unit = ', lun_multi_smoosh
;	write the output header:
		printf, lun_multi_smoosh,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a0," pha data for multi panel smoosh plots --- run time: ",a0)'
		printf, lun_multi_smoosh,  9, multi_panel_out, format='(" Number of header lines:",i4, 6x,"Plot length is ",i3," days")
		printf, lun_multi_smoosh,' ',format='(a1)'
		printf, lun_multi_smoosh,   10., 70., $
		       format='(" PHA limits:  mass between ",f6.2," and ",f6.2," AMU",/)'
		print_multi_panel_intervals, lun_multi_smoosh, multi_panel_start_mjd, multi_panel_stop_mjd
		printf, lun_multi_smoosh,format='($," Time,year,day of year,delta t/2,Mass (AMU),Einc tof (MeV/nuc),")'
;		printf, lun_multi_smoosh,format='($,"time rotated to Earth-Sun line,year rotated to Earth-Sun line,day rotated to Earth-Sun line,GSE-X (AU),GSE-Y (AU),GSE-Z (AU),Earth - Sun - STEREO-A (deg),Earth - Sun - STEREO-B (deg),STEREO-B - Sun - STEREO-A (deg),")'			
		printf, lun_multi_smoosh,' ',format='(a1)'

;	*************** 2014-07-21
;				smoosh		    2014/07/14 13:09:39,     2014.533009,      195.548370, 0.,  4.1807e+01,  2.2353e-01,
		printf, lun_multi_smoosh, yr_header,mo_header,da_header, mjd2decyr(timeheader), mjd2decdoy(timeheader),  format="(i5,'/',i2.2,'/',i2.2,' 00:00:00,',2(f16.6,','),' 0.0,  0.0000e+00,  0.0000e+00,')"


end
