FUNCTION  MAKE_multi_panel_FILENAME, TYPE
;
;	procedure to construct SIT LISTER output file names
;
;	gm	16-Apr-2007    adapted from make_lister_filename.pro
;
;	use:  FILENAME = string with output file name
;		TYPE = string with file type (e.g., rate, bea, hk, pha)


common spacecraft
common time_bounds
common paths
common multi_panel_plot_items
	
		filename = ''

		mjd2date, multi_panel_start_mjd, year, month, day

;		find the day of year
		doy = ulong(multi_panel_start_mjd)-date2mjd(year,1,1)+1
		
		if(spacecraft_id eq 0 ) then spacecraft = "A_" else spacecraft = "B_"

		return, output_file_path + 'SIT_' + spacecraft + string(year, doy, format='(i4,"_",i3.3,"_")') + type + '.txt'
		end
		
; common multi_panel_plot_items, multi_start_mjd, multi_stop_mjd 