FUNCTION  MAKE_LISTER_FILENAME, TYPE
;
;	procedure to construct SIT LISTER output file names
;
;	gm	18-Oct-2006
;
;	use:  FILENAME = string with output file name
;		TYPE = string with file type (e.g., rate, bea, hk, pha)


common spacecraft
common time_bounds
common paths
	
		filename = ''
;		find the year for this date
		mjd2date, start_mjd, year, month, day
;		find the day of year
		doy = ulong(start_mjd)-date2mjd(year,1,1)+1
		
		if(spacecraft_id eq 0 ) then spacecraft = "A_" else spacecraft = "B_"

; print, "JM - creating ", output_file_path + 'SIT_' + spacecraft + string(year, doy, format='(i4,"_",i3.3,"_")') + type + '.txt'
		return, output_file_path + 'SIT_' + spacecraft + string(year, doy, format='(i4,"_",i3.3,"_")') + type + '.txt'
		end
		
