PRO GET_START_STOP_TIME, input_file
;
;	reads start & stop times from inputfile
;
;	gm	25-Aug-2006
;		Modification history:
;			21-Mar-2007	remove seconds on input start and stop times;  resolution is to minute only /gm
;			2-Apr-2007	add swoosh period reading
;			9-May-2011	add calculation of hour & min values from decimal day if day variable is not integer /gm
;			13-Dec-2012	if bound flag = 3 then exit loop doing conversions of decimal time to hr/min  /gm
;
;
;	returns start and stop times as MJD times
;	
;	function used:  date2mjd(year,month,day)
;		related functions:  	date2mjd(year,month,day) or date2mjd(year,doy)
;						date = mjdstr(mjd)


common sitcom
common calibration
common spacecraft
common lun_numbers
common time_bounds


;	read_ascii, skipping 1 header line -- read in all the control lines
	if(interval_number eq 0) then begin
		time_data = read_ascii(input_file,data_start=1,delimiter=' ',count=number_times)
;		start_times=time_data.(0)(0:4,*)
;		stop_times=time_data.(0)(5:9,*)
;		control_flag=time_data.(0)(10,*)
	ENDIF
	
;	*********************** if the day value is not an integer, REPLACE the hour & minute *****************
;	*********************** values on the input line with calculated hour & minute values  *****************
;	*********************** based on the fraction of the day given in the day variable /gm ****************

	for i = 0, (number_times - 1) do begin
	if( floor(time_data.(0)(2,i)) ne time_data.(0)(2,i) ) then begin
		print, 'calculating start hours & minutes from decimal day: ', time_data.(0)(2,i) 
		time_data.(0)(3,i) = floor(24*(time_data.(0)(2,i)-floor(time_data.(0)(2,i))))
		time_data.(0)(4,i) = floor((24*(time_data.(0)(2,i)-floor(time_data.(0)(2,i))) mod 1)*60.+ 0.01)
	endif
	if( floor(time_data.(0)(7,i)) ne time_data.(0)(7,i) ) then begin
		print, 'calculating stop hours & minutes from decimal day: ', time_data.(0)(7,i) 
		time_data.(0)(8,i) = floor(24*(time_data.(0)(7,i)-floor(time_data.(0)(7,i))))
		time_data.(0)(9,i) = floor((24*(time_data.(0)(7,i)-floor(time_data.(0)(7,i))) mod 1)*60.+ 0.01)
	endif
;	if this line has a bound_flag of 3, then exit the loop    12/13/2012
	if( time_data.(0)(10,i) eq 3 ) then break
	endfor

;	****************************************************************************************************

	
;	save the times in a temporary structure
		time_data_temp = time_data
;	now step through time data and set up the swoosh intervals and controlling times
		t_start_hi = dblarr(number_times)  ; holds the start times at high energies
		t_stop_hi = dblarr(number_times)   ;               stop   "
		t_start_lo = dblarr(number_times)   ;               start times at low energy
		t_stop_lo = dblarr(number_times)    ;               stop   "
		swoosh_flag = intarr(number_times)

;	set up the times and swoosh intervals
	int_number = -1
	for i = 0, (number_times - 1) do begin
	
		int_number = int_number + 1
		if(time_data.(0)(10,i) le 3) then begin
			time_data.(0)(0:10,int_number) = time_data_temp.(0)(0:10,i)
			t_start_hi(int_number) = 	date2mjd(time_data_temp.(0)(0,i),time_data_temp.(0)(1,i),time_data_temp.(0)(2,i)) + $
			    					double(time_data_temp.(0)(3,i)/24.d0) + double(time_data_temp.(0)(4,i)/(24.d0*60.d0))					
			t_stop_hi(int_number) = date2mjd(time_data_temp.(0)(5,i),time_data_temp.(0)(6,i),time_data_temp.(0)(7,i)) + $
			    double(time_data_temp.(0)(8,i)/24.d0) + double(time_data_temp.(0)(9,i)/(24.d0*60.d0))
			t_start_lo(int_number) = t_start_hi(int_number)
			t_stop_lo(int_number) = t_stop_hi(int_number)
		ENDIF else begin
;		swoosh period case  -- note:  the time_data entries are the place where the data input begins and ends, so must be the min
;						and max values of the start and stop times
;				first, get the MJD start and stop times
			t_start_hi(int_number) = 	date2mjd(time_data_temp.(0)(0,i),time_data_temp.(0)(1,i),time_data_temp.(0)(2,i)) + $
			    					double(time_data_temp.(0)(3,i)/24.d0) + double(time_data_temp.(0)(4,i)/(24.d0*60.d0))					
			t_stop_hi(int_number) = date2mjd(time_data_temp.(0)(5,i),time_data_temp.(0)(6,i),time_data_temp.(0)(7,i)) + $
							    double(time_data_temp.(0)(8,i)/24.d0) + double(time_data_temp.(0)(9,i)/(24.d0*60.d0))	
			t_start_lo(int_number) = 	date2mjd(time_data_temp.(0)(0,i+1),time_data_temp.(0)(1,i+1),time_data_temp.(0)(2,i+1)) + $
			    					double(time_data_temp.(0)(3,i+1)/24.d0) + double(time_data_temp.(0)(4,i+1)/(24.d0*60.d0))					
			t_stop_lo(int_number) = date2mjd(time_data_temp.(0)(5,i+1),time_data_temp.(0)(6,i+1),time_data_temp.(0)(7,i+1)) + $
			    					double(time_data_temp.(0)(8,i+1)/24.d0) + double(time_data_temp.(0)(9,i+1)/(24.d0*60.d0))	
;			now set up the processing interval based min and max start and stop times
			if(t_start_hi(int_number) le t_start_lo(int_number) )	then time_data.(0)(0:4,int_number) = time_data_temp.(0)(0:4,i) $
				else time_data.(0)(0:10,int_number) = time_data_temp.(0)(0:10,i+1) 
			if(t_stop_hi(int_number) gt t_stop_lo(int_number) )	then time_data.(0)(5:9,int_number) = time_data_temp.(0)(5:9,i) $
				else time_data.(0)(5:9,int_number) = time_data_temp.(0)(5:9,i+1) 
;		set the control flag to look like a "regular" period
			time_data.(0)(10,int_number) = time_data_temp.(0)(10,i) - 3
;		bump loop counter
			i++
;		set flag to identify this time interval as a swoosh interval
			swoosh_flag(int_number) =  1
		ENDELSE
;		check for end of period (control = 3 or 6)
		if( time_data.(0)(10,int_number) eq 3) then break

	ENDFOR

	number_times = int_number + 1    ;  int_number started counting at 0
	
	
;	control_flag
;		= 1, there is another interval after this one that is to be added to present interval
;		= 2, output result after this interval, then get a new interval
;		= 3, output result after this interval and quit
;		= 4, 5, 6:  this is a swoosh interval; so get second set of times, otherwise treat as ctl flag = 1, 2, or 3

;	nsc:  0 = Ahead  (234);   1 = Behind (235)
	i=interval_number



	start_MJD  = date2mjd(time_data.(0)(0,i),time_data.(0)(1,i),time_data.(0)(2,i)) + $
			    double(time_data.(0)(3,i)/24.d0) + double(time_data.(0)(4,i)/(24.d0*60.d0))

	stop_MJD  = date2mjd(time_data.(0)(5,i),time_data.(0)(6,i),time_data.(0)(7,i)) + $
			    double(time_data.(0)(8,i)/24.d0) + double(time_data.(0)(9,i)/(24.d0*60.d0))
	control_flag=time_data.(0)(10,i)
	
	interval_number++

;		modified output statement with function mjd2modayrhrmn()   2/4/08   /gm
;	printf, lun_print,mjd2modayrhrmn(start_MJD), mjd2modayrhrmn(stop_MJD), time_data.(0)(10,i), start_MJD, stop_MJD,  $
;		 format='("processing interval:  ",i2,"/",i02,"/",i4,x,i02,":",i02," to ", i2,"/",i02,"/",i4,x,i02,":",i02,", control flag = ",i1,", Start/stop MJD: ",2f12.3)'
		 
end

