	PRO	CORRECT_MRATE_BACKGROUND
;
;	routine to correct matrix rate values for background
;
;	10-Apr-2007	Initial version /gm
;	12-Apr-2007	implement spillover correction calculated using hex boxes of 041107
;
	common background_correction
	common rate_averages
	common output_items
	common spacecraft

; ********************** correct for spillover and bin width ***************
;	correction is for 3He boxes only  (note:  this section can return negative value, but will be zeroed in further down
	for i = 19, 28 do begin
		mrate_average(i) = box_width_adjust(i)*(mrate_average(i) - mrate_average(spillover_box(i))*spillover_fraction(i))
		mrate_sigma(i) = box_width_adjust(i)*mrate_sigma(i)
	endfor


; ********************** subtract background flux ************************

;	process matrix rates only (rates 0-6 not affected)
	for i = 7,115 do begin
;	check to see that this rate has a correction (must be flux or fluence output)
	if( (bkgd_flux(i,spacecraft_id) gt 0.) and (mrate_average(i) gt 0.) ) then begin


		if( type_out eq 0 ) then fraction = bkgd_flux(i,spacecraft_id)/mrate_average(i) else fraction = (bkgd_flux(i,spacecraft_id)*num_avg_ints_rates*60.)/mrate_average(i)
		if( type_out eq 0 ) then mrate_average(i) = mrate_average(i) - bkgd_flux(i,spacecraft_id) else $
			mrate_average(i) = mrate_average(i) - bkgd_flux(i,spacecraft_id)*num_avg_ints_rates*60.    ; correct for flux vs fluence -- note may have problems if swoosh period
;		don't return negative rates
			if( mrate_average(i) le 0) then mrate_average(i) = 0.
			if( mrate_average(i) gt 0) then mrate_sigma(i) = mrate_sigma(i)*sqrt(1. + fraction^2) else mrate_sigma(i) = 0.


	ENDIF  ; end of background corrections
			
			
			
	ENDFOR  ; loop for correcting boxes
	
	end