	PRO	CORRECT_MPHA_RATE_BACKGROUND
;
;	routine to correct matrix rate values for background
;
;	10-Apr-2007	Initial version /gm
;	12-Apr-2007	implement spillover correction calculated using hex boxes of 041107
;	3-Oct-2008	change "mpha_rate_average" to "mpha_rate_out" in line 31 per Radoslav e-mail 10/2/08; fixed again (?) 15-Mar-2012 /gm
	common background_correction
	common pha_rate_averages
	common output_items
	common spacecraft
	

; ********************** correct for spillover and bin width ***************
;	correction is for 3He boxes only  (note:  this section can return negative value, but will be zeroed in further down
	for i = 19, 28 do begin
;	if(i eq 27) then print, " original values: ", i, mpha_rate_out(i), mpha_rate_out(spillover_box(i)), spillover_fraction(i)

		mpha_rate_out(i) = box_width_adjust(i)*(mpha_rate_out(i) - mpha_rate_out(spillover_box(i))*spillover_fraction(i))
		mpha_rate_sigma_out(i) = box_width_adjust(i)*mpha_rate_sigma_out(i)
;	if(i eq 27) then print, " values after spillover correction: ", i, mpha_rate_out(i), mpha_rate_out(spillover_box(i)), spillover_fraction(i)
	endfor


; ********************** subtract background flux ************************

;	process matrix rates only (rates 0-6 not affected)
	for i = 7,115 do begin

;	check to see that this rate has a correction (must be flux or fluence output)
	if( (bkgd_flux(i,spacecraft_id) gt 0.) and (mpha_rate_out(i) gt 0.) ) then begin
		if( type_out eq 0 ) then fraction = bkgd_flux(i,spacecraft_id)/mpha_rate_out(i) else fraction = (bkgd_flux(i,spacecraft_id)*num_avg_ints_pha_rates*60.)/mpha_rate_out(i)    
		if( type_out eq 0 ) then mpha_rate_out(i) = mpha_rate_out(i) - bkgd_flux(i,spacecraft_id) else $
			mpha_rate_out(i) = mpha_rate_out(i) - bkgd_flux(i,spacecraft_id)*num_avg_ints_pha_rates*60.    ; correct for flux vs fluence -- note may have problems if swoosh period
;		don't return negative rates
			if( mpha_rate_out(i) le 0) then mpha_rate_out(i) = 0.
			if( mpha_rate_out(i) gt 0) then mpha_rate_sigma_out(i) = mpha_rate_sigma_out(i)*sqrt(1. + fraction^2) else mpha_rate_sigma_out(i) = 0.


;	if(i eq 27) then print, " final values: ", i, mpha_rate_out(i),mpha_rate_sigma_out(i)		
	
	ENDIF  ; end of background corrections
;		if( (i ge 70) and (i le 72) ) then stop	
			
	ENDFOR  ; loop for correcting boxes
;	stop
	end
	
