PRO	CHECK_SW_LOOKUP, SITHKDATA, CURRENT_MJD
;
;	checks that the current software version and lookup table checksum from the hk packet have the expected values
;	if unexpected result, type out a message
;
;	18-Oct-2006	/gm
;	26-Aug-2008	fixed date ranges of checksum dates to take account of floating point mjd /gm
;	12-Sep-2008	additionial fixes put in for SIT-B;  add exit_status flag /gm
;	18_May-2009	add patch to suppress SIT-B checksum error messages due to STEREO-B reset & table reload, 5/13-14/09   /gm
;	25-Aug-2009    add patch to suppress SIT-A checksum error messages due to STEREO-A reset & table reload, 8/4-5/09   /gm
;	1-Nov-2010	add line to handle new SIT-B tables of 102910  /gm
;	14-Jan-2011	add line to handle reload of SIT-B tables on 1/10/2011 /gm
;	20-Apr-2011	add lines to handle new SIT-A tables of 041511 /gm
;	9-May-2011	add lines to handle new SIT-B tables of 041811 /gm
;	23-Sep-2011	add line to handle reload of SIT-A tables on 9/21/2011 /gm
;	4-Sep-2012	removed change to check on SIT-B due to mix up of data on 2012/198-199 /gm
;	31-Oct-2012	turned off sw alarm on 10/27/2012 (mjd 56227) to suppress sit-b message triggered
;				by sw vers = 6 (indstead of 602) at time 2012/10/27 19:44:30 (recovered in next records) /gm
;	14-Jul-2014	add line to skip error message on sit-a table reload 7/11/2014 (mjd 56849) /gm
;	13-Jul-2015 add lines to handle table load updates July 9-14, 2015 /gm
;	27-Aug-2015 modify lines to handle upload of 041511 tables after conjunction, done 8/26/2015, mjd 57260  /gm


	common spacecraft
	common time_bounds
	common exit_status

	if( spacecraft_id ne 0 ) then goto, behind	
;
;	STEREO-AHEAD lookups
;		software version
	if((current_mjd gt 53893) and (current_mjd lt 99999)) then if(sithkdata.sw_version ne '0602'XU) then begin 
			print, ' unexpected software version, date: ', sithkdata.sw_version, current_mjd
			exit_status_flag = 1    ; set flag for error message on exit
		endif
		
;		lookup table checksum -- do not check on days of commanding, when several checksums are present; note:  current_mjd is floating point
;	tables 4/28/06  (in use from 6/7/2006, mjd 53893, to 3/14/07, mjd 54173)
	if((current_mjd gt 53893) and (current_mjd lt 54173)) then if(sithkdata.lookup_checksum ne '52A82E'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd

;	tables 3/5/07, loaded 3/14/07	(mjd 54173)
	if((current_mjd gt 54174) and (current_mjd lt 54202)) then if(sithkdata.lookup_checksum ne '953589'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd
	
;	tables 041107, loaded 4/12/07	 (mjd 55047)
	if((current_mjd gt 54203) and (current_mjd lt 55046)) then if(sithkdata.lookup_checksum ne '96324E'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd
		
;	tables 041107, re-loaded 8/5/2009	 (mjd 55048)   after STEREO-A reset  8/4/2009
	if((current_mjd gt 55049) and (current_mjd lt 55670)) then if(sithkdata.lookup_checksum ne '96324E'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd

;	tables 041511, loaded 4/20/11	 (mjd 55671)
	if((current_mjd gt 55672) and (current_mjd lt 99999.) and $
		( floor(current_mjd) ne 55825.) and $		; this date skipped due to table reload 9/21/2011 (mjd 55825)
		( floor(current_mjd) ne 56849.) and $		; this date skipped due to table reload 7/11/2014 (mjd 56849) 
		( (floor(current_mjd) lt 57212.) and (floor(current_mjd) gt 57260.) ) $		; this range of dates skipped due to table uploads July 9- Aug 26, 2015
  		) then if(sithkdata.lookup_checksum ne '9BB5F7'XUL) then begin 
			print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd
			exit_status_flag = 2    ; set flag for error message on exit
		endif
	
	return

behind:
;
;	STEREO-BEHIND lookups
;
;		software version
	if((current_mjd gt 53893) and (current_mjd lt 99999) and ( floor(current_mjd) ne 56227.) ) then if(sithkdata.sw_version ne '0602'XU) then begin 
			print, ' unexpected software version: ', sithkdata.sw_version
			exit_status_flag = 3    ; set flag for error message on exit
		endif
		
;		lookup table checksum
;	tables 4/28/06
	if((current_mjd gt 53893) and (current_mjd lt 54139)) then if(sithkdata.lookup_checksum ne '46E9B7'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd

;	SIT-B SEU 2/8/07-2/21/07	(mjd range 54139-54152)
	if((current_mjd gt 54140) and (current_mjd lt 54151)) then if(sithkdata.lookup_checksum ne '4EE9B7'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd

;	reload 4/28/06 tables on 2/21/07 (mjd 54152)
	if((current_mjd gt 54153) and (current_mjd lt 54173)) then if(sithkdata.lookup_checksum ne '46E9B7'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd

;	tables 3/5/07, loaded 3/14/07	(mjd 54173)
	if((current_mjd gt 54174) and (current_mjd lt 54202)) then if(sithkdata.lookup_checksum ne '6E496A'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd

;	tables 041107, loaded 4/12/07	 (mjd 54202)
	if((current_mjd gt 54203) and (current_mjd lt 54339)) then if(sithkdata.lookup_checksum ne '6F4C8F'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd

;	tables 082307, loaded 8/28/07 (MJD: 54340) through STEREO-B reset & reload of original tables on 5/13/09 (mjd 54964)
	if((current_mjd gt 54341) and (current_mjd lt 54964)) then if(sithkdata.lookup_checksum ne '774376'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd

;	tables 082307, re-loaded 5/14/2009 (MJD: 54965)
	if((current_mjd gt 54966) and (current_mjd lt 55510)) then if(sithkdata.lookup_checksum ne '774376'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd

;	tables 102910, loaded 11/10/2010 (MJD: 55510) through IMPACT overcurrent shutdown & reload of original tables on 1/10/2011 (mjd 55571)
	if((current_mjd gt 55511) and (current_mjd lt 55572)) then if(sithkdata.lookup_checksum ne '9d98f6'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd

;	tables 102910,  reload of original tables on 1/10/2011 (mjd 55572)
	if((current_mjd gt 55573) and (current_mjd lt 55686)) then if(sithkdata.lookup_checksum ne '9d98f6'XUL) then print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd
	
;	tables 041811,  loaded on 5/5/2011 (mjd 55686)
	if((current_mjd gt 55687) and (current_mjd lt 99999)) then begin 

			if(sithkdata.lookup_checksum ne '7963e9'XUL) then begin 
				print, ' unexpected lookup table checksum, date: ', sithkdata.lookup_checksum, current_mjd
				exit_status_flag = 4    ; set flag for error message on exit
			endif
	endif	

	return
	end
