PRO	CALC_BOX, iunit, sitphadata
;
;	procedure to calculate matrix box, etc., from SIT PHA data and using input hex tables
;
;	19-Oct-2006	/gm
;
;	Modification history:
;		29-Aug-2007	check boxes only for data starting after date of current table
;		7-Mar-2013	add check for zero pha in sit-a;  add email messages on error /gm
;		16-Jul-2014	suppress SIT-A error messages for 0 pha events on mjd 56849 (reboot after lobe tests) /gm
;	
;	input:  iunit is spacecraft number (0,1);  sitphadata is pha packet structure
;	output:  through common box_check
;
common hex_tables	  ; hex files for matrix box check, etc.  
common box_check
common output_items
common lun_numbers
common exit_status

	current_mjd = double(sitphadata.header.timeCDS.mjd) + double(sitphadata.header.timeCDS.time)/double(86400.*1000)
	if( current_mjd lt (hex_table_mjd+1) ) then return   ; box check only data beginning with the day after the current table load date (earlier
;												data will have already been checked, and there is no purpose in repeating the check)

;	set error flag if pha packets with 0 events found after SEP central patches to drop such packets:  
	if( sitphadata.num_pha eq 0 ) then begin
		num_pha_error = 0
		if( (iunit eq 0 ) and (current_mjd ge 56349.) and $
			( floor(current_mjd) ne 56849 ) and ( floor(current_mjd) ne 57212 ) and $
			( floor(current_mjd) ne 57213 )) 				then num_pha_error = 1    ; set flag for error message on exit if num_pha = 0 for sit-a after 2/25/2013
;												skip this for days when SEP central patches being reinstalled (7/11/2014; 7/9/2015, 7/10/2015)
		if( (iunit eq 1 ) and (current_mjd ge 56364.) ) then num_pha_error = 1    ; set flag for error message on exit if num_pha = 0 for sit-b after 3/12/2013		
		if( num_pha_error eq 1 ) then begin
			print, 'num_pha  = 0 error for unit:  ', iunit, ' at ', current_mjd, sitphadata.num_pha
			exit_status_flag = 7
		endif
	endif
;	print, 'entering calc box, num_pha = ', sitphadata.num_pha, current_mjd
	
	ntop = sitphadata.num_pha-1
	if(sitphadata.num_pha gt 64)  then begin 
		printf, lun_print, ' cal_box: num_pha out of bounds: ', sitphadata.num_pha, ' at ', mjd2strdayhrmin(current_mjd)
		ntop = 63
	ENDIF
	
	for i = 0, ntop do begin
		issdch = sitphadata.energy_ch(i)
		igain =  sitphadata.gain(i)
		itofch =  sitphadata.tof_ch(i)
;	calculate ixbin, and iybin		
		channel_to_fme_int, iunit, issdch, igain, itofch,  ixbin, iybin
		ibox_contents = 0U
		if((ixbin gt 0) and (iybin gt 0) ) then ibox_contents = ibox_array(ixbin-1, iybin-1, iunit) ; adjust for IDL array
																	; start a ch 0
		
		calc_matrix_box(i) = ibox_contents mod 128
		calc_pri(i) = ishft( ibox_contents, -7 ) mod 2
		calc_bea_box(i) = ishft( ibox_contents, -8 ) mod 16
		m_box_err(i) = 0
		p_box_err(i) = 0
		
		if((calc_matrix_box(i) - sitphadata.matrix_box(i)) ne 0) then m_box_err(i) = 1
		if((calc_pri(i) -  sitphadata.priority(i)) ne 0 ) then p_box_err(i) = 1

	ENDFOR
	
	bad_box_count = ulong(bad_box_count) + ulong(total(m_box_err))
	if((total(m_box_err) gt 0) and (bad_box_count lt 25 )) then begin
		printf, lun_print, ' packet with ', total(m_box_err), ' bad matrix boxes encountered at ',  mjd2strdayhrmin(current_mjd)	
	exit_status_flag = 6    ; set flag for error message on exit
	endif
	
	end
