PRO ADD_RATES, sitratedata
;
;	adds in the current packet's rates to the averaging bins and updates counters
;
common rate_averages
common mbox_factors
common spacecraft
common rate_information
common output_items

common lun_numbers

	discrate_average = discrate_average + sitratedata.DRATES


;	test line for one count per minute
;	sitratedata.MRATES[0:115] = 1.   

;	now fold in efficiencies, delat_e and geometry factor, and do test for each rate box falling into swoosh interval

	for i = 0,115 do begin
		if(  swoosh_test( (matrix_rates[i].emin_nominal(spacecraft_id) + matrix_rates[i].emax_nominal(spacecraft_id))/2.  ) or (i  le 6) ) then begin
;			type_out =0,1 then intensity or fluence units
			if(type_out lt 2) then begin
				mrate_average[i] = ulong(mrate_average[i]) + sitratedata.MRATES[i]/(effic(spacecraft_id,i)*delta_e(spacecraft_id,i)*geom_factor) 
				print, i,  sitratedata.MRATES[i], effic(spacecraft_id,i), delta_e(spacecraft_id,i), geom_factor 
			endif
				
;			type_out = 2, total counts
			if(type_out eq 2) then mrate_average[i] = ulong(mrate_average[i]) + sitratedata.MRATES[i]
		ENDIF
	ENDFOR
	stop	

;	now keep track of counts for later use in computing sigmas
	mrate_counts = mrate_counts + sitratedata.MRATES


	utc_average_time = 	utc_average_time +double(sitratedata.header.timeCDS.mjd) + double( sitratedata.header.timeCDS.time)/86400000.d0 

	num_avg_ints_rates ++
;	print, ' add rates: ',	utc_average_time,   num_avg_ints_rates
	
;			printf, lun_spectralist, 	utc_average_rates.mjd,  utc_average_rates.time,   num_avg_ints_rates
	
	bin_last_rates = bin_now_rates

end
