PRO add_pha_rates_times
;
;	updates the pha_times and matrix rate counters for each minute (apid 605)
;
;	extract from add_pha_rates to just add in the times for each apid 605 packet encountered; 3/11/2013 /gm
;	change from ulong() to double() in lines 38 and 40 to prevent floating illegal operand errors; 2/12/14 /gm

	common pha_rate_averages
 	common calibration
 	common spacecraft
	common rate_information
	common rate_averages
	common output_items	
	common mbox_factors
	

;	
;	************************** add a separate tally of rate data for use in this routine ****************************

; add in PHA live time (1 min) only for APID 605
		num_avg_ints_pha_rates ++
		utc_average_pha_rates.mjd = double(utc_average_pha_rates.mjd) + double(sitratedata_last.header.timeCDS.mjd)
		utc_average_pha_rates.time = double(utc_average_pha_rates.time) + double(sitratedata_last.header.timeCDS.time)
		utc_average_pha_time = 	utc_average_pha_time +double(sitratedata_last.header.timeCDS.mjd) + double( sitratedata_last.header.timeCDS.time)/86400000.d0 


	discrate_average_pha_ctr += sitratedata_last.DRATES


;	test line for one count per minute
;	sitratedata_last.MRATES[0:115] = 1.   

;	now fold in efficiencies, delat_e and geometry factor, and do test for each rate box falling into swoosh interval

	for i = 0,115 do begin
		if(  swoosh_test( (matrix_rates[i].emin_nominal(spacecraft_id) + matrix_rates[i].emax_nominal(spacecraft_id))/2.  ) or (i  le 6) ) then begin
;			type_out =0,1 then intensity or fluence units
			if(type_out lt 2) then mrate_average_pha_ctr[i] = double(mrate_average_pha_ctr[i]) + sitratedata_last.MRATES[i]/(effic(spacecraft_id,i)*delta_e(spacecraft_id,i)*geom_factor)
;			type_out = 2, total counts
			if(type_out eq 2) then mrate_average_pha_ctr[i] = double(mrate_average_pha_ctr[i]) + sitratedata_last.MRATES[i]
		ENDIF
	ENDFOR


;	now keep track of counts for later use in computing sigmas
	mrate_counts_pha_ctr += sitratedata_last.MRATES

; ****************************** keep track of last bin number **********************
		bin_last_pha_rates = bin_now_pha_rates

	return


	end
