PRO add_pha_rates, sitphadata, apid
;
;	adds in the current packet's rates to the averaging bins and updates counters
;
;		split off from write_pha_spectra 4/27/2011 /gm
;		add trap for junk events 6/22/2011 /gm
;		add trap for rom box = 0 events 7/9/2011 (occur if JNK command = 1) /gm
;		modify to just process the pha_rates, timing and matrix rates handled in add_pha_rates_times 3/11/3013 /gm

	common pha_rate_averages
 	common calibration
 	common spacecraft
	common rate_information
	common rate_averages
	common output_items	
	common mbox_factors



; ****************************** keep track of last bin number **********************
		bin_last_pha_rates = bin_now_pha_rates
	
	
; ****************************** add in this packet's pha data into the intensity totals *****************************


	ntop = sitphadata.num_pha-1
	if( ntop eq 0 ) then return			; *************** 5/17/2011
	if(ntop gt 63) then ntop = 63
	   for i = 0, ntop do begin 

;		skip events that have a rom box number of 0 (will be telemetered if JNK command bit set = 1 as in test 2007/Feb 22-Mar 14
		if( sitphadata.matrix_box(i) eq 0 ) then goto, nextevent 
	   
	   		amass = amass_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id)
	   		einc = einc_tof_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id)
	   		
	   	; find box number
;	   		box = -1
;	   		for j=7,115 do begin
;	   		box=j
;	   		if( (einc ge matrix_rates(j).emin_nominal(spacecraft_id)) and (einc lt matrix_rates(j).emax_nominal(spacecraft_id)) and $
;	   			(amass ge matrix_rates(j).mass_min(spacecraft_id)) and (amass lt matrix_rates(j).mass_max(spacecraft_id)) ) then break
; ************ splitting up this if statement so tests can end at any stage cuts time for 1/30/07 processing from 48 to 25 sec ****************	   			
;	   		if(einc ge matrix_rates(j).emin_nominal(spacecraft_id)) then $
;	   			if (einc lt matrix_rates(j).emax_nominal(spacecraft_id)) then  $
;		   			if(amass ge matrix_rates(j).mass_min(spacecraft_id)) then $
;		   				if (amass lt matrix_rates(j).mass_max(spacecraft_id)) then $
;		   					if(swoosh_test(einc)) then break
;	   			
;	   		ENDFOR
;		if( box eq 95 ) then stop
;	use of where statement instead of loop lookup cuts 2011/152 sit-b processing from 70 to 38 s   / 6/23/2011
		box = where ( 	(einc ge matrix_rates.emin_nominal(spacecraft_id)) and $
	   				(einc lt matrix_rates.emax_nominal(spacecraft_id)) and  $
		   			(amass ge matrix_rates.mass_min(spacecraft_id)) and $
		   			(amass lt matrix_rates.mass_max(spacecraft_id)) and $
		   			(swoosh_test(einc)) )

;	if event passes more than one test, then use the lowest box number
		if( n_elements(box) gt 1 ) then box = min(box)
	   		
;	if no box found, then is junk event so just bump the low priority matrix rate counter
;		if( box eq -1 ) then mpha_priority_counts(0) =double(mpha_priority_counts(0)) + 1
;			box = sitphadata.matrix_box(i) - 1  ; test case for box definition  5/9/2011

; 	if box found, then add in the count to the mbox and priority counter
;	NOTE:  must use the priority assigned by the on-board rate processor since that is what determined the priority handling of 
;		event!	6/28/2011
	   		if( box ge 0) then mpha_rate_counts(box,sitphadata.priority(i)) =   double(mpha_rate_counts(box,sitphadata.priority(i))) + 1
	  		mpha_priority_counts(sitphadata.priority(i)) =double(mpha_priority_counts(sitphadata.priority(i))) + 1


;			if(box eq 57) then print, box, sitphadata.priority(i), einc, amass, mpha_rate_counts(box,sitphadata.priority(i))
;			if( mpha_rate_counts(57,sitphadata.priority(i)) eq 20 ) then stop

;			if(box eq 71) then print, i, box, mpha_rate_counts(box,sitphadata.priority(0)), einc, amass,sitphadata.energy_ch(i),sitphadata.tof_ch(i),sitphadata.matrix_box(i), format='(10i6)'

;			if(box eq 20) then print, i, box, mpha_rate_counts(box,sitphadata.priority(0)), einc, amass
;			if(sitphadata.matrix_box(i) eq 20) then print, i, box, mpha_rate_counts(box,sitphadata.priority(0)), einc, amass
;			j=box
;			if(sitphadata.matrix_box(i) eq 20) then print, matrix_rates(j).emin_nominal(spacecraft_id), matrix_rates(j).emax_nominal(spacecraft_id)
;	   		if(sitphadata.matrix_box(i) eq 20) then print, matrix_rates(j).mass_min(spacecraft_id), matrix_rates(j).mass_max(spacecraft_id)

nextevent:  
	
	ENDFOR
	

	
	return


	end
