PRO ADD_HK, sithkdata
;
;	adds in the current packet's hk values to the averaging bins and updates counters
;	mod 20-Mar-2007  /gm
;
common hk_averages

;	if sithkdata not defined, skip this call
	if(size(sithkdata,/type) ne 8 ) then return
	
;	if the HK channel numbers are zero, skip this packet
	if( total(sithkdata.hk_item) eq 0 ) then return

	
	hk_average = hk_average + sithkdata.hk_item + 0.0D0
	mf_num_av = mf_num_av + ulong(sithkdata.mf_number) + 0.0D0
	tof_gain_av = tof_gain_av + sithkdata.tof_gain + 0.0D0
	tof_cal_av = tof_cal_av + sithkdata.tof_cal + 0.0D0
	tof_cal_err_av = tof_cal_err_av + sithkdata.tof_cal_error + 0.0D0
	sw_version_avg = sw_version_avg + sithkdata.sw_version + 0.0D0
	lookup_checksum_avg = lookup_checksum_avg + sithkdata.lookup_checksum + 0.0D0
	

	utc_average_hk.mjd = utc_average_hk.mjd + sithkdata.header.timeCDS.mjd
	utc_average_hk.time = utc_average_hk.time + sithkdata.header.timeCDS.time

	num_avg_ints_hk =  num_avg_ints_hk + 1
	bin_last_hk = bin_now_hk
	sithkdata_last = sithkdata           ; save last packet for use in write subroutine	
end