@/data/joey/mdesai/Desktop/IDL/ace/top_level/programs/convert_udf_times.pro

pro SITB_L1_4he_data_compare

;
; program to plot and 1-Hour averaged SIT L1 data with local data production 
; Original M. Desai 2/23/16
;

output_plot_folder = "/data/joey/mdesai/Desktop/IDL/masongm1/Data/Production/STEREO/5_Berkeley_L1_checks/L1_check_plots/"

; set the plotting device

dme = 1
spect = 9



!p.thick    = 2
!x.ticklen  = 0.08
!y.ticklen  = 0.04      
!x.thick=2
!y.thick=2
csize=1.5
syms  = 0
ebars = 1
lthick = 5
ssize = 1.0

; set up a simple color table

;if (dme eq 1) then begin
bbc = 255b
bfg = 0b
;endif else begin
;   bbc = 0b
;   bfg = 255b
;endelse

if (n_elements(red) eq 0) then begin
  red = [bbc, bfg, 255b, 0b, 0b, 0b, 255b, 255b, 255b, 127b, 0b, $
    0b, 127b, 255b, 85b, 170b]
  gre = [bbc, bfg, 0b, 255b, 0b, 255b, 0b, 255b, 127b, 255b, 255b, $
    127b, 0b, 0b, 85b, 170b]
  blu = [bbc, bfg, 0b, 0b, 255b, 255b, 255b, 0b, 0b, 0b, 127b, $
    255b, 255b, 127b, 85b, 170b]
endif else begin
  red(0:1) = [bbc, bfg]
  gre(0:1) = [bbc, bfg]
  blu(0:1) = [bbc, bfg]
endelse
tvlct, red, gre, blu
tvlct, bfg, bfg, bfg, !d.n_colors-1

names = ['ahead','behind']
file_index = ['a','b']
lastplot_year = lonarr(2)
lastplot_day = lonarr(2)
status_flag = 0 ; (exit status)     exit status
;             1 = one or both spacecraft have new data
;             0 = no new data found

openr, lun_lastcheck, '/data/joey/masongm1/Data/Production/STEREO/0_batch_jobs/logs/last_L1_verification.txt', /get_lun
times = fltarr(4,2)
mjd_max = fltarr(2)
for i_sc = 0, 1 do begin
  readf,  lun_lastcheck, t1, t2, t3, t4   ; latest data yr, doy    last processed yr, doy
  times(0,i_sc) = t1
  times(1,i_sc) = t2
  times(2,i_sc) = t3
  times(3,i_sc) = t4
endfor    ; i_sc loop
free_lun, lun_lastcheck

for i_sc = 0,1 do begin
  ; open stereo data file list
  openr, lun_stereo, '/data/joey/masongm1/Data/Production/General/get_data/data_status/stereo_L1_files.txt', /get_lun
  instring=''
  ;STA_L1_SIT_20100201_V01.cdf
  while( eof(lun_stereo) ne 1 ) do begin
    readf, lun_stereo, instring
    loc = strpos(strlowcase(instring),'.')
    if( strlowcase(strmid(instring,2,1)) eq file_index(i_sc) ) then begin
      if( loc gt 0 ) then begin
        reads, strmid(instring,loc-12,4), year
        reads, strmid(instring,loc-8,2), month
        reads, strmid(instring,loc-6,2), day
        mjd = date2mjd(year, month, day)
        if( mjd gt mjd_max(i_sc)) then mjd_max(i_sc)= mjd
      endif
    endif
  endwhile
  free_lun, lun_stereo
endfor   ; end of i_sc loop

; set the status flag  and update the max times if they are beyond prior latest data
status_flag = 0
for i_sc = 0, 1 do begin
  max_date = date2mjd(times(0,i_sc), times(1,i_sc))
  if( mjd_max(i_sc) gt  max_date ) then begin
    status_flag = 1
    mjd2date, mjd_max(i_sc), yr, month, day
    times(0,i_sc) = yr
    times(1,i_sc) = mjd_max(i_sc) - date2mjd(yr,1,1)+1
  endif
endfor   ; end of i_sc loop


latest_data_sita_hours     = hours(times(0:1,0),[95,1]) 
latest_l1check_sita_hours  = hours(times(2:3,0),[95,1])


latest_data_sitb_hours     = hours(times(0:1,1),[95,1])
latest_l1check_sitb_hours  = hours(times(2:3,1),[95,1])

if (latest_data_sitb_hours gt latest_l1check_sitb_hours) then begin

start_year = fix(times(2,1)) 
start_day  = fix(times(3,1)) 

year_string = string(start_year,format="(i4.2)")
sitb_caltech_file_string = "SIT_Behind_1hr_4He_"+year_string+".txt"
sitb_caltech_filename = "/data/joey/mdesai/Desktop/IDL/masongm1/Data/Data_delivered_by_ftp/webfiles_sit_b_1hr/"+sitb_caltech_file_string
sitb_caltech_data = read_ascii(sitb_caltech_filename,data_start = 27,count=number_caltech_points,delimiter=' ')
sitb_caltech_doy  = sitb_caltech_data.(0)(1,*) 
sitb_caltech_4he  = sitb_caltech_data.(0)(7,*) 


doy_string = string(start_day,format="(i3.2)")
sitb_L1_file_string = "stereo_b_"+year_string+"_"+doy_string+"_check.txt" 

sitb_l1_filename = "/data/joey/mdesai/Desktop/IDL/masongm1/Data/Production/STEREO/5_Berkeley_L1_checks/L1_prerelease_check_files/"+sitb_L1_file_string 
sitb_l1_data   = read_ascii(sitb_l1_filename,data_start = 1,count=number_l1_points,delimiter=',')
sitb_l1_4he  = sitb_l1_data.(0)(6,*) 

stop_year = fix(sitb_l1_data.(0)(0,number_l1_points-1))
stop_day  = fix(sitb_l1_data.(0)(1,number_l1_points-1)+1)


if (stop_year mod 4 eq 0) then begin
  if (stop_day gt 366) then begin
       stop_year = stop_year +1
       stop_day = stop_day - 366
  endif
endif  

if (stop_year mod 4 ne 0) then begin
  if (stop_day gt 365) then begin
    stop_year = stop_year +1
    stop_day = stop_day - 365
  endif
endif
       
       

y_vals = fltarr(4)
y_vals = [5e-2,1e-1,5e-3,1e-3]

; get time range

tim_all = [start_year,start_day,0,0,stop_year,stop_day,0,0]

@time_limits
time,tim_all(0:3),tim_all(4:7)


shtim = string(tim_all(0),tim_all(1),tim_all(2),tim_all(3),tim_all(4),tim_all(5),tim_all(6),tim_all(7), $
   format="(i4.2,':',i3.2,':',i2.2,':',i2.2,'-',i4.2,':',i3.2,':',i2.2,':',i2.2)")
shtim = strcompress(shtim,/remove)

file_subscript = string(tim_all(0),tim_all(1), $
   format="(i4.2,'_',i3.3)")
file_subscript = strcompress(file_subscript,/remove)

begt = hours(tim_all(0:1),[95,1]) + tim_all(2) + tim_all(3)/60.
endt = hours(tim_all(4:5),[95,1]) + tim_all(6) + tim_all(7)/60.


  data        = sitb_caltech_data.(0)(0:1,*)
  data        = transpose(data)  
 
  data_size   = size(data)
  data(*,0)   = fix(data(*,0)) 
 
udf_times  = dblarr(data_size(1),2)
udf_times  = data(0:data_size(1)-1,0:1)
udf_hours  = dblarr(data_size(1))
result     = convert_udf_times(udf_times,udf_hours)
sitb_caltech_hours = udf_hours

data        = sitb_l1_data.(0)(0:1,*)
data        = transpose(data)

data_size   = size(data)
data(*,0)   = fix(data(*,0))

udf_times  = dblarr(data_size(1),2)
udf_times  = data(0:data_size(1)-1,0:1)
udf_hours  = dblarr(data_size(1))
result     = convert_udf_times(udf_times,udf_hours)
sitb_l1_hours = udf_hours

n_days = round((endt-begt)/24.)
doy = intarr(n_days + 1)
doy    = tim_all(1) + indgen(n_days+1)
yy     = intarr(n_days + 1) 

date_string = strarr(n_days +1)
result = get_date_string(tim_all,date_string)

sh_tim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
   format="(i4.2,'_',i3.3,'_',i4.2,'_',i3.3)")
sh_tim = strcompress(sh_tim,/remove)

if (dme eq 1) then begin
  psfilename = output_plot_folder + "SIT_B_" + sh_tim + ".ps"
  dev = 'ps'
  set_plot,dev
  if (spect eq 9) then begin
    device,/color,/landscape,filename=psfilename,bits_per_pixel=8,/helvetica,/iso
    device,xsize=26,ysize=20
    device,xoff=1.25,yoff=28.0
  endif
  !p.color=1
  !p.font=0
endif else begin
  plot_open,dme,spect
endelse


;define a solid dot as a symbol

circ=findgen(16)*(!pi*2/16.)
usersym,cos(circ),sin(circ),/fill

plots_across = 1 ; # of plots across the page
plots_down = 1; # of plots down the page

!p.multi=[0,plots_across,plots_down,0,0]

location = fltarr(plots_down,4)
location(0,*) = [0.09,0.08,0.95,0.85]

iyear = tstart(0)
iday  = tstart(1)

ih = tim_all(2)
im = tim_all(3)
eh = tim_all(6)
em = tim_all(7)

; get the data only for the given start and stop times                 

 stime = 0. + ih
 etime = endt - begt + ih

 tst = tim_all(0:1)  

locs_max = where(sitb_caltech_hours ge begt and sitb_caltech_hours le endt, countm)
 if (countm gt 1) then begin
   max_value = max(data(locs_max))
     if (max_value lt 100) then begin
       !y.tickname = ['10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n']
       !y.ticks    = 5
       crangey     = [1e-3,1e+2]
       !y.minor    = 9
       !y.tickv    = [1e-3,1e-2,1e-1,1e0,1e1,1e2] 
     endif else begin
       !y.tickname = ['10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n','10!U3!n','10!U4!n']
       !y.ticks    = 7
       crangey     = [1e-3,1e+4]
       !y.minor    = 9
       !y.tickv    = [1e-3,1e-2,1e-1,1e0,1e1,1e2,1e3,1e4] 
     endelse
 endif else begin 
       !y.tickname = ['10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n','10!U3!n','10!U4!n']
       !y.ticks    = 7
       crangey     = [1e-3,1e+4]
       !y.minor    = 9
       !y.tickv    = [1e-3,1e-2,1e-1,1e0,1e1,1e2,1e3,1e4] 
 endelse 

;stop

; plot proton rates

crangex = [stime,etime]
!p.position = location(0,*)

      timebox, stime, etime, /zero, exact=texact, day=tst,ytype=1, $
      yrange = crangey, yexact = 1, charsize=csize/1.2,$
      ytitle='#/(cm!U2!n s sr MeV/n.)',$
      nolabels=0, minutes = minutes, date = 1,noerase = 0    

xyouts,/norm,0.03,0.91,'STEREO-B/IMPACT/SEP/SIT',charsize=csize/2.75,align=0.0
xyouts,/norm,0.03,0.89,'Top: 0.137 MeV/n. 4He Intensity',charsize=csize/2.75,align=0.0

xyouts,/norm,0.8,0.91,'Created-'+systime(),align=0,charsize = csize/2.75

time_ticks = stime + indgen(n_days+1)*24

for i = 0, n_days do begin
  xyouts,/data,time_ticks(i),crangey(1)*1.5,date_string(i),align =0.5,charsize=csize/1.5
endfor  


data_array = intarr(4)
data_array = indgen(4) + 3
array_name = strarr(4)
array_name = ['!U3!nHe','!U4!nHe','O','Fe']
col_index = intarr(4)
col_index = [1,2,3,4]
  

nume_sitb_caltech = where(sitb_caltech_hours ge begt and sitb_caltech_hours le endt, countm_sitb_caltech)
if (countm_sitb_caltech gt 1) then begin

         !p.color=1
         !p.thick=1
         oplot,sitb_caltech_hours(nume_sitb_caltech)-begt+ih,sitb_caltech_4he(nume_sitb_caltech),psym=4
         oplot,sitb_caltech_hours(nume_sitb_caltech)-begt+ih,sitb_caltech_4he(nume_sitb_caltech)
         !p.color = 1 
        
type_axis = intarr(1)
type_axis = 1

crangex = [stime,etime]

endif

nume_sitb_l1 = where(sitb_l1_hours ge begt and sitb_l1_hours le endt, countm_sitb_l1)
if (countm_sitb_l1 gt 1) then begin

  !p.color=2
  !p.thick=1
  oplot,sitb_l1_hours(nume_sitb_l1)-begt+ih,sitb_l1_4he(nume_sitb_l1),psym=6
  oplot,sitb_l1_hours(nume_sitb_l1)-begt+ih,sitb_l1_4he(nume_sitb_l1)
  !p.color = 1

  type_axis = intarr(1)
  type_axis = 1

  crangex = [stime,etime]

endif

if (countm_sitb_caltech le 0) then begin
 stime = 0. + ih
 etime = endt - begt + ih

 tst = timall(0:1)  

!y.tickname = ['10!U-4!n','10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n','10!U3!n','10!U4!n']
!y.ticks    = 8
crangey     = [1e-4,1e+4]
!y.minor    = 9
!y.tickv    = [1e-4,1e-3,1e-2,1e-1,1e0,1e1,1e2,1e3,1e4] 

; plot proton rates

crangex = [stime,etime]
!p.position = location(0,*)

      timebox, stime, etime, /zero, exact=texact, day=tst,ytype=1, $
      yrange = crangey, yexact = 1, charsize=csize,$
      ytitle='particles/(cm!U2!n s sr MeV/nuc)', $
      nolabels=0, minutes = minutes, date = 1,noerase = 0    

time_ticks = stime + indgen(n_days+1)*24

for i = 0, n_days do begin
  xyouts,/data,time_ticks(i),crangey(1)*1.5,date_string(i),align =0.5,charsize=csize/1.5
endfor  

xyouts,/data,stime+3,crangey(1)/5.,'NO DATA AVAILABLE FOR THIS PERIOD'

!p.color=4
;xyouts,/norm,0.9,0.81,'TF - CME F/S',align=0,charsize = csize/4
;xyouts,/norm,0.9,0.79,'TR - CME R/S',align=0,charsize = csize/4
!p.color=1


xyouts,/norm,0.03,0.89,'Top: 0.137 MeV/n. 4He Intensity',charsize=csize/2.75,align=0.0

xyouts,/norm,0.8,0.91,'Created-'+systime(),align=0,charsize = csize/2.75

endif

; close plotting device

if (dme eq 0) then goto, docomp
if (dme ne 0) then begin
  device,/close
endif
docomp:

endif
;stop




end
