pro	l1_verification

;	Routine to calculate 1-hr averages of SIT level 1 Berkeley CDF files and put out a Kaleidagraph format file
;
;	Modification history
;		March 2008	initial version
;		14-Jul-2008	adjust paths for new directory structure /gm

timeCDS = { MJD: 0L , TIME: 0L }

; mjd_start=54255.   
 mjd_start=54174.   ;   3/15/07   ' day 74
; mjd_end=54517.     ; 2/21/08
 mjd_end=54184.
mjd=mjd_start

outfile = '/users/masongm1/Programs/sit_b_check_mar_3.txt'
	
	spacecraft=''
	read,spacecraft,prompt='enter spacecraft (a or b): '


	data_folder=''
	read, data_folder, prompt='enter the name of the folder with test data, eg, prerelease_2008_04: '
	outfile = '/data/joey/masongm1/Data/work_files_STEREO/SIT_level_1_at_Berkeley/' + data_folder + '/stereo_' + spacecraft + '_check_file.txt'
	print, outfile
	
	read, start_yr, start_mo, start_da, prompt='enter start year, month, day: '
	read, end_yr, end_mo, end_da, prompt='enter end year, month, day: '
 	mjd_start=date2mjd(start_yr,start_mo,start_da)
 	mjd=mjd_start
 	print, ' mjd_start = ', mjd
 	mjd_end=date2mjd(end_yr,end_mo,end_da)
 
 
 
 		openw, lun_outfile, outfile, /get_lun
 		printf, lun_outfile, format='($," year, doy, mjd,mjd from epoch,number of minutes, epoch,")'
 		for i=0,11 do printf, lun_outfile, i+1, format='($,"H ",i3,",")'
 		for i=0,11 do printf, lun_outfile, i+1, format='($,"counts H ",i3,",")'
  		for i=0,9 do printf, lun_outfile, i+1, format='($,"3He ",i3,",")'
  		for i=0,9 do printf, lun_outfile, i+1, format='($,"counts 3He ",i3,",")'
   		for i=0,15 do printf, lun_outfile, i+1, format='($,"4He ",i3,",")'
   		for i=0,15 do printf, lun_outfile, i+1, format='($,"counts 4He ",i3,",")'
		for i=0,16 do printf, lun_outfile, i+1, format='($,"C ",i3,",")'
    		for i=0,16 do printf, lun_outfile, i+1, format='($,"counts C ",i3,",")'
    		for i=0,15 do printf, lun_outfile, i+1, format='($,"O ",i3,",")'
     		for i=0,15 do printf, lun_outfile, i+1, format='($,"counts O ",i3,",")'
    		for i=0,15 do printf, lun_outfile, i+1, format='($,"NeS ",i3,",")' 		
    		for i=0,15 do printf, lun_outfile, i+1, format='($,"counts NeS ",i3,",")' 
       		for i=0,13 do printf, lun_outfile, i+1, format='($,"Fe ",i3,",")'
       		for i=0,13 do printf, lun_outfile, i+1, format='($,"counts Fe ",i3,",")'
        	for i=0,5 do printf, lun_outfile, i+1, format='($,"UH ",i3,",")'
        	for i=0,5 do printf, lun_outfile, i+1, format='($,"counts UH ",i3,",")'        	
        	printf, lun_outfile, format='($," time,")'
;		write out a character to force a line feed
		printf,  lun_outfile,' ',format='(a1)'

  


while (mjd le mjd_end ) do begin


;filename='/users/masongm1/Programs/prerelease/STA_L1_SIT_20070327_V01.cdf'

date= mjd2modayrhrmn(mjd)


; filename = '/users/masongm1/Programs/prerelease/STA_L1_SIT_' + string(date(2),date(0),date(1),format='(i4,2i02)') + '_V01.cdf'
 filename = '/data/joey/masongm1/Data/work_files_STEREO/SIT_level_1_at_Berkeley/' + data_folder + '/ST' + spacecraft + '_L1_SIT_' + string(date(2),date(0),date(1),format='(i4,2i02)') + '_V01.cdf'

print,filename

 loadallcdf, data=sitdata, file=filename
;	 print,tag_names(sitdata)


; print,n_elements(sitdata)

limit = n_elements(sitdata) - 1

;	help,sitdata,/st



		index = 0



		h_counts=fltarr(12)
		he3_counts=fltarr(10)
		he4_counts=fltarr(16)
		c_counts=fltarr(17)
		o_counts=fltarr(16)
		nes_counts=fltarr(16)
		fe_counts=fltarr(14)
		uh_counts=fltarr(6)
		
		
 		for ihr = 0, 23 do begin
; 		print,ihr,index

;	if(limit lt 1439 ) then print,i, index,limit
 			epoch_sum=sitdata(index).epoch
 			h_sum=sitdata(index).h_intensity
 			he3_sum=sitdata(index).he3_intensity
 			he4_sum=sitdata(index).he4_intensity
 			c_sum=sitdata(index).c_intensity
 			o_sum=sitdata(index).o_intensity
 			nes_sum=sitdata(index).nes_intensity
 			fe_sum=sitdata(index).fe_intensity
 			uh_sum=sitdata(index).uh_intensity
 			time_sum=sitdata(index).time
 			

 			for  j = 0,11 do if( sitdata(index).h_sigma(j) > 0 ) then  h_counts(j)=(sitdata(index).h_intensity(j)/sitdata(index).h_sigma(j))^2 else h_counts(j)=0.
 			for  j = 0,9 do if( sitdata(index).he3_sigma(j) > 0 ) then  he3_counts(j)=(sitdata(index).he3_intensity(j)/sitdata(index).he3_sigma(j))^2 else he3_counts(j)=0.
 			for  j = 0,15 do if( sitdata(index).he4_sigma(j) > 0 ) then  he4_counts(j)=(sitdata(index).he4_intensity(j)/sitdata(index).he4_sigma(j))^2 else he4_counts(j)=0.
 			for  j = 0,16 do if( sitdata(index).c_sigma(j) > 0 ) then  c_counts(j)=(sitdata(index).c_intensity(j)/sitdata(index).c_sigma(j))^2 else c_counts(j)=0.
  			for  j = 0,15 do if( sitdata(index).o_sigma(j) > 0 ) then  o_counts(j)=(sitdata(index).o_intensity(j)/sitdata(index).o_sigma(j))^2 else o_counts(j)=0.
   			for  j = 0,15 do if( sitdata(index).nes_sigma(j) > 0 ) then  nes_counts(j)=(sitdata(index).nes_intensity(j)/sitdata(index).nes_sigma(j))^2 else nes_counts(j)=0.
    			for  j = 0,13 do if( sitdata(index).fe_sigma(j) > 0 ) then  fe_counts(j)=(sitdata(index).fe_intensity(j)/sitdata(index).fe_sigma(j))^2 else fe_counts(j)=0.
    			for  j = 0,5 do if( sitdata(index).uh_sigma(j) > 0 ) then  uh_counts(j)=(sitdata(index).uh_intensity(j)/sitdata(index).uh_sigma(j))^2 else uh_counts(j)=0.
 		
 		minutes = 1.   ; we've already added in the first minute!
 		for  i = 1, 59 do begin
;			print,i,index,minutes

 				epoch_sum += sitdata(index).epoch
 				h_sum += sitdata(index).h_intensity
 				he3_sum += sitdata(index).he3_intensity
 				he4_sum += sitdata(index).he4_intensity
 				c_sum += sitdata(index).c_intensity
 				o_sum += sitdata(index).o_intensity
 				nes_sum += sitdata(index).nes_intensity
 				fe_sum += sitdata(index).fe_intensity
 				uh_sum += sitdata(index).uh_intensity
 				time_sum += sitdata(index).time
; 				print,time_sum, minutes, sitdata(index).time
 			
 				for  j = 0,11 do if( sitdata(index).h_sigma(j) > 0 ) then  h_counts(j) += (sitdata(index).h_intensity(j)/sitdata(index).h_sigma(j))^2
 				for  j = 0,9 do if( sitdata(index).he3_sigma(j) > 0 ) then  he3_counts(j) += (sitdata(index).he3_intensity(j)/sitdata(index).he3_sigma(j))^2
 				for  j = 0,15 do if( sitdata(index).he4_sigma(j) > 0 ) then  he4_counts(j) += (sitdata(index).he4_intensity(j)/sitdata(index).he4_sigma(j))^2
 				for  j = 0,16 do if( sitdata(index).c_sigma(j) > 0 ) then  c_counts(j) += (sitdata(index).c_intensity(j)/sitdata(index).c_sigma(j))^2
  				for  j = 0,15 do if( sitdata(index).o_sigma(j) > 0 ) then  o_counts(j) += (sitdata(index).o_intensity(j)/sitdata(index).o_sigma(j))^2
   				for  j = 0,15 do if( sitdata(index).nes_sigma(j) > 0 ) then  nes_counts(j) += (sitdata(index).nes_intensity(j)/sitdata(index).nes_sigma(j))^2
    				for  j = 0,13 do if( sitdata(index).fe_sigma(j) > 0 ) then  fe_counts(j) += (sitdata(index).fe_intensity(j)/sitdata(index).fe_sigma(j))^2
    				for  j = 0,5 do if( sitdata(index).uh_sigma(j) > 0 ) then  uh_counts(j) += (sitdata(index).uh_intensity(j)/sitdata(index).uh_sigma(j))^2
			
			index ++
			if(index gt limit) then goto, output
			minutes ++ 


 		endfor
; divide by minutes

output  :			if( minutes ge  0. ) then begin
				epoch_sum /= minutes 
 				h_sum /= minutes
 				he3_sum /= minutes 
 				he4_sum /= minutes 
 				c_sum /= minutes 
 				o_sum /= minutes 
 				nes_sum /= minutes 
 				fe_sum /= minutes 
 				uh_sum /= minutes 

 				time_sum /= minutes 
; 				 				print,time_sum, minutes
			ENDIF


; print out the line 			
 			decmjd = mjd*1.d0 +(index-30.)/1440.d0
 			year = date(2)
 			timecds.mjd = mjd
 			timecds.time = (index-30.)*60000.
 			doy = mjd2decdoy(timecds)
 			
 			 printf,lun_outfile, year,doy, decmjd, unix_mjd(time_sum), minutes, epoch_sum,h_sum,h_counts,he3_sum,he3_counts, $
 			 	he4_sum,he4_counts,c_sum,c_counts,o_sum,o_counts,nes_sum,nes_counts,fe_sum,fe_counts,time_sum,$
 			 	uh_sum,uh_counts, format = '(1x,2(e12.4,","), 2(e20.9,","), 250(e12.4,","))' 
; 			 stop
			if(index gt limit) then goto, nextday
 			 
 			 ENDFOR

nextday:  		mjd ++

 
 ENDWHILE ; -- mjd loop

 end
 
