#!/bin/bash

# update the data files first: 

# Example bash shell script to setup an environment for idl,
# and run an idl process. This script could be called via cron.
# In shell scripts, lines starting with "#" are comments.

# This file must be made executable, via the command
# "chmod +x run_idl.bash"

# Call the script to setup the environment for idl. This is essential if this script is called via cron, since cron jobs do not inherit the user's full login environment.
/Applications/rsi/idl/bin/idl_setup.bash
export PATH=${PATH}:/Applications/rsi/idl_6.3/bin/

# if you need to add pointers to directories where you
# keep various idl library routines, do this here.
# This is a colon-separated list. The "+" tells idl to
# search subdirectories.
# export IDL_PATH=+/usr/local/rsi/idl_6.1:+/users/asc/DPE
# export IDL_PATH=+/Applications/rsi/idl_6.3/:+/Users/masongm1/Desktop/SIT_idl/

# Change directory to where you want to run your job
# cd /users/ad/gmtest
cd /Users/masongm1/Data/Production/STEREO/1_basicrates_update/ 

# Generally, this shell script might contain commands here to
# figure out some parameters that the idl job might need, such
# as, what are the new input files that need to be processed since
# the last time the job was run, etc. 
# But that's beyond the scope of this example

# Run your idl job. idl will execute the commands in the .bat file.
# "-quiet" suppresses the startup messages, etc.
#  idl -quiet idl_batch_example.batch
# idl  -quiet sit_update_a.batch
idl  -quiet sit_update_a.batch

	mail -s "SIT-A status update" mdesai@swri.edu < /Users/masongm1/Data/Basicrates/STEREO/SIT_A_2008_183_batch.txt

# now do SIT-B

idl  -quiet sit_update_b.batch

	mail -s "SIT-B status update" mdesai@swri.edu < /Users/masongm1/Data/Basicrates/STEREO/SIT_B_2008_183_batch.txt
