PRO SIT_TEST
; INFILENAME  < -- put this back on  first line when batch stuff worked out
;+
; Project     :	STEREO - IMPACT, SIT
;
; Name        : SIT_TEST
;
; Purpose     :	Test program to read SIT packets sequentially and extract a few items
;
; Category    :	STEREO, IMPACT, SIT
;
; Explanation :	reads a STEREO telemetry data file and extracts some items from
;		SIT packets.
;
; Syntax      :	
;
; Examples    :	
;
; Inputs      :	Filename of telemetry data file (containing Payload telemetry packets).
;
; Opt. Inputs :	None.
;
; Outputs     :	None
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	sit_common, read_stereo_pkt, parse_stereo_pkt
;
; Common      :
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (example), 28-Jun-2006, Andrew Davis, Caltech
;
;-
;

  sit_common ; setup SEP beacon global variables

  ; Open input data file for reading.
  ; printf,-2,'Opening input file'
; read in SIT calibration data
restore_cal


infilename='users/masongm1/desktop/sit_data/prelaunch_data/sit_behind_2006_307_1_00.ptp'
print, ' opening: ',infilename

  openr, unit, infilename, /get_lun, error = error_flag
  IF (error_flag ne 0) then BEGIN
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
  ENDIF 

  packet = 0

  WHILE 1 DO BEGIN
     read_stereo_pkt, unit, packet
     if n_elements(packet) eq 0 then break
     apid = parse_stereo_pkt(packet, /APID )

     ; send SIT rate packet (apid=6o5) to SIT rate processing.
     ; The sitratedata structure is returned undefined if there was an error.
     ; The definition of the sitratedata structure is in sit_rates.pro.
     IF apid eq 605 THEN BEGIN
        sit_rates, packet, sitratedata

	; do something useful with the SIT rate data structure here
	IF n_elements(sitratedata) ne 0 THEN BEGIN
           printf,-2, "date/time, scid: ", utc2str(sitratedata.header.timeCDS), sitratedata.header.SCid
           printf,-2, "DRATES: ", sitratedata.DRATES
	   printf, -2, "HVstep: ", sitratedata.hvstep
	ENDIF
     ENDIF
  ENDWHILE
  
  free_lun, unit
  
end 
