PRO READ_SEP_BEACON_FACTORS, INFILENM

; open factors file and read in all the factors
; Oct  11 2005, Andrew Davis, Caltech

common sep_b

openr, f_unit, INFILENM, /get_lun, error = error_flag
IF (error_flag ne 0) then BEGIN
    printf, -2, !err_string
    exit, /NO_CONFIRM, STATUS=-1
ENDIF 

tmp = ''
a1 = 0.0D
a2 = 0.0D
a3 = 0.0D
a4 = 0.0D
a5 = DINDGEN(4)
a6 = DINDGEN(4)


WHILE (tmp ne 'HET_BEGIN') DO BEGIN
   READF, f_unit, tmp
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'Premature EOF finding HET Factors...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   
FOR i=0,NHET -1 DO BEGIN
   READF, f_unit,tmp,a1,a2,a3,a4, FORMAT= '(A16,D0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'Premature EOF reading HET Factors...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.HET_fctrs[i].Elo = a1
   Factors.HET_fctrs[i].Ehi = a2
   Factors.HET_fctrs[i].geom = a3
   Factors.HET_fctrs[i].effic = a4
;   printf, -2, a1, a2, a3, a4
ENDFOR

WHILE (tmp ne 'SIT_BEGIN') DO BEGIN
   READF, f_unit, tmp
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'Premature EOF finding SIT Factors...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   
FOR i=0,NSIT -1 DO BEGIN
   READF, f_unit,tmp,a1,a2,a3,a4, FORMAT= '(A16,D0,D0,D0,D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'Premature EOF reading SIT Factors...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.SIT_fctrs[i].Elo = a1
   Factors.SIT_fctrs[i].Ehi = a2
   Factors.SIT_fctrs[i].geom = a3
   Factors.SIT_fctrs[i].effic = a4
;   printf, -2, a1, a2, a3, a4
ENDFOR

WHILE (tmp ne 'LET_BEGIN') DO BEGIN
   READF, f_unit, tmp
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'Premature EOF finding LET Factors...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   
FOR i=0,NLET -1 DO BEGIN
   READF, f_unit,tmp,a1,a2,a5,a6, FORMAT= '(A16,D0,D0,4D0,4D0)'
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'Premature EOF reading LET Factors...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.LET_fctrs[i].Elo = a1
   Factors.LET_fctrs[i].Ehi = a2
   Factors.LET_fctrs[i].geom = a5
   Factors.LET_fctrs[i].effic = a6
;   printf, -2, tmp, a1, a2, a5, a6
ENDFOR

WHILE (tmp ne 'SEPT_BEGIN') DO BEGIN
   READF, f_unit, tmp
   IF EOF(f_unit) THEN BEGIN
      printf,-2, 'Premature EOF finding SEPT Factors...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
ENDWHILE   
FOR i=0,NSEPT -1 DO BEGIN
   READF, f_unit,tmp,a1,a2,a3,a4, FORMAT= '(A16,D0,D0,D0,D0)'
   IF EOF(f_unit) AND i LT (NSEPT-1) THEN BEGIN
      printf,-2, 'Premature EOF reading SEPT Factors...exiting'
      free_lun, f_unit
      exit, /NO_CONFIRM, STATUS=-1
   ENDIF
   Factors.SEPT_fctrs[i].Elo = a1
   Factors.SEPT_fctrs[i].Ehi = a2
   Factors.SEPT_fctrs[i].geom = a3
   Factors.SEPT_fctrs[i].effic = a4
;   printf, -2, a1, a2, a3, a4
ENDFOR

free_lun, f_unit


END
