PRO BEACON_DRIVER,INFILENAME
;+
; Project     :	STEREO - IMPACT, LET
;
; Name        : BEACON_DRIVER
;
; Purpose     :	Test program to feed IMPACT beacon packets to SEP Beacon processing routines
;
; Category    :	STEREO, IMPACT, SEP
;
; Explanation :	reads STEREO telemetry data and passes
;               IMPACT beacon packets (apid=624) to SEP Beacon processing.
;               Also, calls sep_beacon_common to setup SEP beacon common block
;
; Syntax      :	
;
; Examples    :	
;
; Inputs      :	Filename of telemetry data file (PTP or STP).
;               NOTE: Currently expects a 32-byte file header which is present
;                     in telemetry data files from LET MSU calibration run. This
;                     header will not be present in standard packet data.
;
; Opt. Inputs :	None.
;
; Outputs     :	None
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	sep_beacon_common, read_stereo_pkt, parse_stereo_pkt, sep_beacon
;
; Common      :
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 26-Sep-2005, Andrew Davis, Caltech
;
; Contact     :	ad@srl.caltech.edu
;-
;

  sep_beacon_common ; setup SEP beacon global vars, is there a better way?

  ; Open input data file for reading.
  ; printf,-2,'Opening input file'

  openr, unit, infilename, /get_lun, error = error_flag
  IF (error_flag ne 0) then BEGIN
      printf, -2, !err_string
      exit, /NO_CONFIRM, STATUS=-1
  ENDIF 

  ; read in the 32-byte header at the start of each LET MSU accelerator
  ; calibration telemetry data file. Apart from this header, the file
  ; is in Payload telem pkt format.
  ; MSU_header=BYTARR(32)
  ; readu,unit,MSU_header

  packet = 0
  sepbeacondata = 0

  WHILE 1 DO BEGIN
     read_stereo_pkt, unit, packet
     if n_elements(packet) eq 0 then break
     apid = parse_stereo_pkt(packet, /APID )

     ; send IMPACT beacon packets (apid=624) to SEP beacon processing.
     ; sepbeacondata structure is returned undefined if there
     ; was an error processing a packet
     IF apid eq 624 THEN BEGIN
        sep_beacon, packet, sepbeacondata

	; do something useful with the SEP beacon data structure here
	IF n_elements(sepbeacondata) ne 0 THEN BEGIN
;           printf,-2,sepbeacondata.header.timeCDS
;           printf,-2, sepbeacondata.status.HETLiveTime
           printf,-2, sepbeacondata.status.HETLiveTime, sepbeacondata.status.LETLiveTime, sepbeacondata.status.LETMinute
;           printf,-2, sepbeacondata.LETflux
;           printf,-2, sepbeacondata.LETcounts
;	   PRINTF, -2, FORMAT='(%"SEPTStatus: %x ")', sepbeacondata.status.SEPTStatus
;           sepbeacondata.status.LETAcceptCnts, $
;           sepbeacondata.status.LETMinute, sepbeacondata.status.LETDyThState, $
; 	   sepbeacondata.status.LETCodeOK, sepbeacondata.status.LETLeakConv
	ENDIF
     ENDIF
  ENDWHILE
  
  free_lun, unit
  
end ; beacon_driver
