; Version Date: 30 September 1999, Author: M. E. Hill
; Space Physics Group, U. of Maryland, Dept. of Physics
; SEE HELP FEATURE PRINT STATEMENTS FOR MODIFICATIONS AND EXPLANATIONS

PRO ShowMatrix, $;this is an IDL program template
; LIST ALL ARGUMENTS HERE:
              image              , $ ;The (1D or 2D) matrix to be displayed
              x,y                , $ ;offset (NORMAL-ized) coordinates wrt the lower left corner
              xsi,ysi            , $ ; optional (*) same as the xsize and ysize keywords
; LIST ALL KEYWORDS HERE:
           HELP=help             , $ ; the standard help feature should be retained
           NOERROR=NOerror,        $	; Set to turn off error handling (used for debugging)
           xsize=xsize,ysize=ysize,$ ;(NORMAL-ized) dimensions of the matrix image to plot (*)
           _REF_EXTRA=refex       ,$ ;used to pass keywords to the TV procedure
           USEAXES=useaxes,        $ ;set to use X & Y axes for image sizing
           USEXAXIS=useXaxis,      $ ; fit to pre-existing x-axis
           USEYAXIS=useYaxis,      $ ; fit to pre-existing x-axis
           SHOWHEADING=showheading,$ ; the heading is suppressed unless requested        
           SETX=setX,SETY=setY,    $ ; use when using USEAXES keywords
           GETSIZE=getsize           ; returns [x,y,xsize,ysize] (in NORMAL coords) for image
                                     ; define variable to nonzero value before setting to keyword
                         
;this procedure is intended to be a "generic" device-independent version of the
;IDL TV procedure.  It uses exclusively NORMALIZED units to avoid device dependency
;it accepts the same keywords and arguments as the TV procedure

RoutineName = "SHOWMATRIX" ;**change**these**when**renaming**
HLINE =     '---------------------------------------------------------------------'
HTITL =     'S H O W M A T R I X . P R O     30 SEP 1999 (M E Hill)   Voyager/LECP'

; ERROR HANDLING
IF keyword_set(NOerror) THEN error_status = 0 ELSE BEGIN
  CATCH, error_status
ENDELSE
IF error_status EQ 0 THEN BEGIN
  NO_error = 1; there are no errors
ENDIF ELSE BEGIN
  dummy = dialog_message(!ERROR_state.MSG + "  " + RoutineName + $
                         "  will now end.")  
  NO_error = 0; there is an error
ENDELSE

IF NO_error THEN BEGIN
  IF keyword_set(showheading) OR keyword_set(help) THEN BEGIN ;OR keyword_set(help) THEN BEGIN 
    print,' ' & print,HLINE & print, ' ' & print, HTITL & print, ' '
  ENDIF
  IF keyword_set(help) THEN BEGIN ; help feature was requested
    IF min(byte(help) EQ 1) THEN BEGIN
      print,"The intent of this routine is to standardize IDL's TV procedure so   "
      print,'that 2D array images (or matrix images) can be displayed easily and  '
      print,'in a device independent manner.  ShowMatrix will accept most of the  '
      print,'same keywords as TV, plus some additional ones.  This procedure, un- '
      print,'like TV, uses only NORMAL units, to avoid device dependence.'
      print,'The call sequence is:   ShowMatrix,image,x,y,Xsi,Ysi     , where the '
      print,'information about the listed arguments can be found at the "argument"'
      print,'help-topic.  Only image is a required argument. '
      print,' ' & print,'Example:' & print,' '
      print,'ShowMatrix,[[1,2,3],[4,5,6]]*50,.1,.1,.5,.5 ; this call will display the'
      print,'             ; the given matrix, with the lower left corner of the   '
      print,'             ; image offset by 10% of the window or page size.  The  '
      print,'             ; size of the image will be 50% of the page/window size.'
      print,' '
      print,'ENTER: '+RoutineName+",help = 'argument' for more'
      print,'      information about arguments."
      print,'ENTER: '+RoutineName+",help = 'keyword' for more'
      print,'      information about keywords.'
      print,'ENTER: '+RoutineName+",help='modification' for a list"
      print,'      of dates and changes to this source code since its creation.'
    ENDIF ELSE IF strupcase(help) EQ 'MODIFICATIONS' THEN BEGIN
      print,'HELP:',help & print,' '
      print,'  Modification history for this routine:'
      print,'  28 SEP 1999 (M E Hill)	 - The "new" ShowMatrix is created'
      print,'  29 SEP 1999 (M E Hill)    - Fine tuning and help/error features    '
      print,'                              toggled on or off (for debugging use). '
      print,'  30 SEP 1999 (M E Hill)    - remove old USEAXES code, keep new code '
    ENDIF ELSE IF strupcase(help) EQ 'ARGUMENT' THEN BEGIN
      print,'HELP:',help & print,' '
      print,'The call sequence is:   ShowMatrix,image,x,y,Xsi,Ysi'
      print,'There are up to five arguments, with one required argument.  In order'
      print,'they are:'
      print,'IMAGE  This is the required argument, it is the (1D or) 2D array to  '
      print,'       be displayed.  3D or greater arrays are not allowed.          '
      print,'X      This is an optional offset of the image from the right edge of'
      print,'       the window or page.  The units are NORMAL units, meaning that '
      print,'       they specify the fraction of the window/page, from 0.0 to 1.0 '
      print,'Y      This is an optional offset of the image from the bottom edge. '
      print,'Xsi    This is an alternative form of the XSIZE keyword, specifying  '
      print,'       the size of the image to be displayed in the horizontal direc-'
      print,'       tion, in NORMAL coordinates.'
      print,'Ysi    Same as Xsi, except specifies the vertical size of the image. '
    ENDIF ELSE IF strupcase(help) EQ 'KEYWORD'  THEN BEGIN
      print,'HELP:',help & print,' '
      print,'GETSIZE     Set this to a declared non-zero variable to get a four-  '
      print,'            element array returned which specifies the size and      '
      print,'            location of the displayed image in NORMAL coordinates.   '
      print,'HELP        Activates the help feature by setting (to one) or by set-'
      print,"            ting to a help-topic string, such as 'argument'          "
      print,"NOerror     set this keyword to turn off the error handling features."
      print,"            (This is useful for debugging of the procedure.)         "
      print,'setX        When the useYaxis keyword is used, setX should be set to '
      print,'            the X-offset, just as argument "X" would be used.        '
      print,'setY        When the useXaxis keyword is used, setY should be set to '
      print,'            the y-offset, just as argument "Y" would be used.        '
      print,'SHOWHEADING This will display the program name heading when set.     '
      print,'USEAXES     Set this keyword to force the matrix-image to fit into a '
      print,'            pre-existing set of axes.                                '
      print,'useXaxis    Set this keyword to line the x-offset and x-size of the  '
      print,'            image with a pre-existing set of plotting axes.  The setY'
      print,'            and Ysize keywords should be set to define the size and  '
      print,'            location of the image in the y-direction.                '
      print,'useYaxis    Set this keyword to line the y-offset and y-size of the  '
      print,'            image with a pre-existing set of plotting axes.  The setX'
      print,'            and Xsize keywords should be set to define the size and  '
      print,'            location of the image in the X-direction.                '
      print,'Xsize       Set this to a value between 0.0 and 1.0 (inclusive) to   '
      print,'            specify the size of the image in the horizontal direc-   '
      print,'            tion.  (Use like the TV keyword of the same name, with   '
      print,'            NORMAL coordinate setting.)                              '
      print,'Ysize       Set this to a value between 0.0 and 1.0 (inclusive) to   '
      print,'            specify the size of the image in the vertical direc-     '
      print,'            tion.  (Use like the TV keyword of the same name, with   '
      print,'            NORMAL coordinate setting.)                              '
      print,'other       Other kleywords (not above) will be sent to the TV pro-  '
      print,'            cedure (see IDL documentation).                          '
    ENDIF ELSE IF strupcase(help) EQ 'HELP'     THEN BEGIN
      print,'HELP:',help & print,' '
      print,'This keyword enables the HELP feature of this routine.'
      print,'It can be set equal to one (using the /help syntax) to get
      print,'general help information for this routine.  Also, the help keyword'
      print,'can be set equal to a string corresponding to a help topic.  When '
      print,'this is done, more information of that topic will be displayed.'
      print,'When the help feature is used, all other program features are'
      print,'over-ridden.  When the help keyword is not set, this routine will'
      print,'run as described in the help documentation.'
      print,'Examples:' & print,' '
      print, RoutineName + ",/help ; this causes the display of general HELP informaion"
      print,' '
      print, RoutineName + ",help = 'help' ;this displays detailed HELP info."
    ENDIF ELSE IF strupcase(help) EQ 'NOERROR'     THEN BEGIN
      print,'HELP:',help & print,' '
      print,'This keyword is designed for users who are debugging or otherwise    '
      print,'programming this routine.  By setting this keyword, the error-       '
      print,'handling is turned off.  This allows a programmer to discover and    '
      print,'correct errors easily, whereas the error-handling can slow that      '
      print,'process down.  NOerror should not be used during general runs of this'
      print,"routine as IDL's 'Variable Context' can cause variables on the main  '
      print,'programming level to seem to disappear.  This can cause errors in    '
      print,'this or other routines.  The error-handling avoids these problems.   '
      print,'Example:' & print, ' '
      print, RoutineName + ",/NOerror ;this will toggle off the error-handling"
      print, RoutineName + ",NOerror=0 ;this has no effect, as error-handling"
      print,'                          ; is the default setting."
    ENDIF ELSE BEGIN
      print,'HELP:',help & print,' '
      print,"Sorry, but your help-command was unclear."
      print,"Currently each argument or keyword does not have its own help-topic. "
      print,"       Try typing " + RoutineName + ",/help"
    ENDELSE
  ENDIF ELSE BEGIN ;help feature was not used...run main program
    IF keyword_set(showheading) THEN BEGIN
      print, ' '
      print,"(You may type "+RoutineName+",/help for help in using "+RoutineName+","
      print,"after you have completed the current run.)"
    ENDIF
;* * * * * * * * * * * * * * * * * * *
;* * * MAIN PROGRAM  BEGINS HERE * * *
;* * * MAIN PROGRAM  BEGINS HERE * * * (start main program source code in column 1)
;* * * * * * * * * * * * * * * * * * *

IF !d.name EQ 'PS' THEN PSmode = 1 ELSE PSmode = 0 ; To save memory when plotting on the PS device,
                                                   ; it is necessary to plot in a different manner.
                                                   ; The problem is in using CONGRID with PS since
                                                   ; the PS device has many-many more pixels and thus,
                                                   ; the new matrix created this way would be huge.
                                                   ; Since PS is a scalable device...it is more memory
                                                   ; efficient to use TV directly (w/o CONGRID)

IF N_params() EQ 1 THEN BEGIN ;the supplied argument is the matrix
  x = 0 & y = 0
ENDIF ELSE IF N_params() EQ 2 THEN BEGIN
  y = 0
ENDIF
IF NOT keyword_set(setX) THEN setX = 0.
IF NOT keyword_set(setY) THEN setY = 0.
IF NOT keyword_set(xsize) THEN xsize = ((1.-2.*x)*(x LT .5) + (.5 - 2.*(x-.5))*(X GT .5))>.01 ;default xsize
IF NOT keyword_set(ysize) THEN ysize = ((1.-2.*y)*(y LT .5) + (.5 - 2.*(y-.5))*(y GT .5))>.01 ;default ysize
    
IF N_params() EQ 4 THEN BEGIN
  xsize = xsi
ENDIF ELSE IF N_params() EQ 5 THEN BEGIN
  ysize = ysi & xsize = xsi
ENDIF 

IF keyword_set(useXaxis) OR keyword_set(useaxes) THEN BEGIN ; overrides parameters & keywords
  x = !x.window[0]
  xsize = !x.window[1] - x
  IF NOT keyword_set(useaxes) THEN y = setY
ENDIF

IF keyword_Set(useYaxis) OR keyword_set(useaxes) THEN BEGIN ; overrides parameters & keywords
  y = !y.window[0]
  ysize = !y.window[1] - y
  IF NOT keyword_set(useaxes) THEN x = setX
ENDIF

Sx = !d.x_size & Sy = !d.y_size ; # of pixels in the window
IF PSmode THEN TV,image,x,y,xsize=xsize,ysize=ysize,/normal,_EXTRA =refex $
ELSE TV,congrid(image,xsize*Sx,ysize*Sy),x,y,/normal,_EXTRA =refex

IF keyword_set(GETSIZE) THEN BEGIN
  GetSize = fltarr(4)
  GetSize = [x,y,xsize,ysize]
ENDIF

;* * * * * * * * * * * * * * * * * * *
;* * * MAIN PROGRAM  ENDS HERE * * * *
;* * * MAIN PROGRAM  ENDS HERE * * * *
;* * * * * * * * * * * * * * * * * * *
  ENDELSE ; end of main program loop
  IF keyword_set(showheading) OR keyword_set(help) THEN BEGIN
    print,' ' & print, HLINE & print, ' ' 
  ENDIF
ENDIF ; end of no-error loop 
END