pro Ymunu, theta, phi, mu, nu, c, s

;+
; YMUNU
;	Returns the spherical harmonic Y^(mu)_(nu)(theta,phi)
;
; Usage:
;	ymunu, theta, phi, mu, nu, c, s
;
; Arguments:
;	theta	float	input	The co-latitude coordinate (radians)
;	phi	float	input	The longitude coordinate (radians)
;	mu	int	input	The order of the function.
;	nu	int	input	The degree of the function.
;	c	float	output	The cosine harmonic
;	s	float	output	The sine harmonic
;
; Method:
;	BFI from the Associated legendre function.
;
; Restriction:
;	Integer order & degree (degree >= 0) (see also pmunu).
;	Theta, phi should have same dimensions.
;
; History:
;	Original: 11/4/95; SJT
;-

z = cos(theta)

y = (-1)^mu * $
  sqrt((2*nu + 1)/(4*!Pi) * fact(nu-mu)/fact(nu+mu)) * $
  pmunu(z, mu, nu)

c = y*cos(mu*phi)
s = y*sin(mu*phi)

end
