function Xdpyinfo, colors=colors, xsize=xsize, display=display, $
                   attribute=attribute, output=output

;+
; Routine: XDPYINFO()
; Keywords:	
;	COLORS		returns the maximum number of colours
;	XSIZE		returns the xsize of the screen in pixcells
;	ATTRIBUTE 	returns 1 if the string in attribute is found
;			e.g. if xdpyinfo(att='labtam') is true for Labtam
;			terminals, (case insensitive)
;	
; 
; Returns the characteristics (number of colors, xsize..) of an
; xwindows display, without first opening it in IDL
; To test for psuedo colour visual, try if xdpyinfo(attrib='pseudo') then ...
; Typical use: xs=xdpyinfo(/xsiz)
;
; NOTE: This is a WORKAROUND!, but this could be replaced with a call
; to IDL's own routines if they ever provide
; a way of interrogating the display without opening it - At the moment, 
; the visual type is committed once you make any enquiries.
;
; History:
;     Original: Unknown; Boyd D. Blackwell (ANU)
;     Add VMS support and cosmetic changes: 6/1/94; SJT
;-

@path_dirs

if (not keyword_set(display)) then begin
    if (!Version.os eq 'vms') then display = 'DECW$DISPLAY' $
    else                         display = '$DISPLAY'
endif

case 1 of
    keyword_set(colors):    str = 'colormap cells'
    keyword_set(xsize):     str = 'imensions'
    keyword_set(attribute): str = attribute
    Else: str = 'imensions'
endcase

; can't use /noshell here if we use xdpyinfo -display ...

if (!Version.os eq 'vms') then begin
    set_symbol, 'XDPYINFO', '$'+form_fname('xdpyinfo', lib_dir), type = 2
    spawn, 'xdpyinfo -display ' + display, output
endif else spawn, /sh,  'xdpyinfo -display '+display+' 2>/dev/null', output

str = strupcase(str)
output = strupcase(output)

wh = where(strpos(output, str) ge 0)
if wh(0) eq -1 then return, 0

first = output(wh(0))     	; first line in which string appears
output=output(wh)		; only those lines which match
if keyword_set(attribute) then begin
    print, first
    return, 1
end

colon = strpos(first, ':') 	;look after the colon
return,fix(strmid(first,colon+1,20))

end
