function timetitle, rawtitle, year, hour=hour, date=date

;+
;  TIMETITLE
;	Add a time to the end of a title.
;
;  Usage:
;	title = timetitle (rawtitle, year[, hour=hour, /date])
;
;  Return Value:
;	title	string	The title to use.
;
;  Arguments:
;	rawtitle string	input	The title-without a time appended.
;	year	int	input	The year (and optionally day) to append.
;
;  Keyword:
;	hour	int	input	The hour to append. 
;	date	?	input	If set convert to month and date.
;
;  Restriction:
;	If rawtitle is set then the returned title is:
;		<rawtitle> - year - day - hour
;	else it is:
;		UT - year - day - hour
;
;  History:
;	Original: 8/12/92; SJT
;	Added date key: 16/2/95; SJT
;	Fix for year >= 2000: 1/12/95; SJT
;-

if n_elements(rawtitle) eq 0 then title = 'UT' $
else if (rawtitle eq '') then title = 'UT' $
else title = rawtitle

if (year(0) lt 0) then return, rawtitle

year(0) = date100(year(0), /full)

if n_elements(year) eq 2 then begin
    if (keyword_set(date)) then begin
        datecon, year(0), year(1), mth, dte
        title = title + string(year(0), mth, dte,  $
                               format = "(' - ',I4,'/',A3,'/',I2)")
    endif else title = title + string(year, format =  $
                                      "(' - ',I4,' - ',I3)") 
endif else title = title + string(year, format="(' - ',I4)")

if (n_elements(hour) ne 0) then $
  title = title + string(hour, format = "(' - ',I2.2)")

return, title
end
