; $Id: str_sep.pro,v 1.1 1993/04/02 19:43:31 idl Exp $

; Copyright(c) 1992-1993, CreaSo Creative Software Systems GmbH. 
;	All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;    STR_SEP
;
; PURPOSE:
;    This routine cuts a string into pieces which are separated by the 
;    separator string.
; CATEGORY:
;    String processing.
; CALLING SEQUENCE:
;    arr = STR_SEP(string, separator)
;
; INPUTS:
;    str - The string to be separated.
;    sep - The separator.
;
; KEYWORDS:
;    None.
;
; OUTPUT: 
;    An array of strings as function value.
;
; COMMON BLOCKS:
;    None
;
; SIDE EFFECTS:
;    No known side effects.
;
; RESTRICTIONS:
;    None.
;
; EXAMPLE:
;    array = STR_SEP ("ulib.usca.test", ".")
;
; MODIFICATION HISTORY:
;	July 1992, AH,	CreaSo		Created.
;	Smooth rough edges: 16/1/94; SJT
;-

function Str_sep, str, sep


n = 0                           ; Determine number of separators in string.
spos = 0
sl = strlen(sep)
repeat begin
    pos = strpos (str, sep, spos)
    spos = pos + sl
    n = n+1
endrep until pos eq -1

arr = strarr(n)                 ; Create result array

spos = 0
for i = 0, n-2 do begin         ; Separate substrings
    pos = strpos (str, sep, spos)
    arr(i) = strmid (str, spos, pos-spos)
    spos = pos+strlen(sep)
endfor

arr(n-1) = strmid(str, spos, strlen(str))

return, arr

end
