;+
; SPAWN_MENU
;	Menu interface for running an OS command.
;
; Usage:
;	spawn_menu
;
; Arguments: none
;
; Keywords:
;	group	long	input	Group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly
;
; History:
;	Original (from plcl_menu): 25/1/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;	Make <cr> = "do it": 12/5/93; SJT
;	Add group=topbase to xdisplayfile: 27/6/94; SJT
;-

pro spawn_event, event

@spawn_wid
@wid_fonts
@wid_set

widget_control, event.id, get_uval=but

case but of
    'BG': iback = event.select

    'RES': widget_control, acttxt, set_value=''

    'NO': begin
	widget_control, event.top, /destroy
	return
    end

    'DO': begin
	widget_control, acttxt, get_value=com
	com = com(0)
	os_com=com
        if com ne '' then begin
	    if (iback) then begin
                if !version.os eq 'vms' then $
				 spawn, com, /nowait, /notify $
		else  spawn, com+' &'
	    endif else begin
		spawn, com, stdoutput
		if (max(strlen(stdoutput)) gt 0) then $
		    hs_displayfile, text=stdoutput, title=com, $
			width=20 > (max(strlen(stdoutput))+3) < 80, $
			height = 5 > n_elements(stdoutput) < 24, $
			font = normal_f, group = topbase
	    endelse
	endif
	widget_control, event.top, /destroy
	return
    end

;	Ignore anything else (i.e. the text widget)
    
    
    else:

endcase

end

pro spawn_menu, group=group

@spawn_wid
@wid_fonts

if (xregistered('spawn')) then return	; Don't make a second copy.

mbuttons = ['Reset', 'Cancel', 'Do it']
muv = ['RES', 'NO', 'DO']
iback = 0
os = strupcase(!version.os)
if (n_elements(os_com) eq 0) then os_com = ''

base = widget_base(/column, title = os+' Command', xpad = 5, ypad = 5)
txt = widget_label(base, value=os+' Command', frame=2, font=large_v)

actbase = widget_base(base, /row)
junk = widget_label(actbase, value=os+' command: ', font=normal_v)
acttxt = widget_text(actbase, /edit, /frame, uvalue='DO', $
	value=os_com, xsize=40, ysize=1, font=normal_f)

jb = widget_base(base, /row)
junk = widget_label(jb, value = 'Run command in:', font = normal_v)
junk = cw_tbutton(jb, value = ['Foreground', 'Background'],  $
                  uvalue = 'BG', font = normal_v, state = iback)

xmenu, mbuttons, jb, /row, uvalue = muv, font = normal_v, /frame

widget_control, base, /real
widget_control, acttxt, /input_focus
xmanager, 'spawn', base, group=group

end
