function Sign, x

;+
; SIGN
;	Return sign of argument
;
; Usage:
;	s=sign(x)
;
; Return:
;	s	-1 where argument is negative, 0 where 0 and 1 where
;		positive. Has the same type and dimensions as the
;		argument
;
; Argument:
;	x	Any 	input	The value of values whose sign is
;				required.
;
; Restrictions:
;	Can't cope with byte, string, complex or structure types
;
; History:
;	Original: 6/9/95; SJT
;-

on_error, 2

if (n_params() ne 1) then message, "Must supply an argument"

s = size(x)
if (s(s(0)+1) le 1 or s(s(0)+1) ge 6) then message, "Illegal data " + $
  "type"

if (s(0) gt 1) then y = make_array(size = s) else y = x

locs = where(x gt 0, n)
if (n gt 0) then y(locs) = 1
locs = where(x lt 0, n)
if (n gt 0) then y(locs) = -1

return, y

end
