function sar, lim1, lim2, trim=trim
;+
;  SAR
;	Return a string array of numbers from lim1 to lim2
;
;  Usage:
;	sa = sar(lim1[, lim2])
;
;  Arguments:
;	lim1	int	input	If 2 args then the lower limit of the array
;				else the upper.
;	lim2	int	input	If given the upper limit of the array.
;
;  Keyword:
;	trim	?	input	If set, then ensure no spaces around
;				the number.
;
;  History:
;	Original: 9/10/92; SJT
;	Add trim keyword: 12/7/95; SJT
;-

if (n_params() eq 1) then begin
    lowlim = 1
    numb = lim1
endif else begin
    lowlim = lim1 < lim2
    numb = (lim2 > lim1) - lowlim + 1
endelse

return, strcompress(string(indgen(numb)+lowlim), $
                    remove = keyword_set(trim))

end
