function pow_ten, v

;+
;  POW_TEN
;	Checks whether the argument is an integer power of 10 or not.
;
;  Usage:
;	pt = pow_ten(v)
;
;  Return Value:
;	pt	byte	1 if (where) v is a power of 10,
;			0 if (where) v is not a power of 10.
;
;  Argument:
;	v	any	input	Thw value(s) to be checked.
;
;
;  Restrictions:
;	Won't work for strings or structures.
;
;  History:
;	Original: 17/2/92; SJT
;-

s = size(v)
t = n_elements(s) - 2
if (s(t) ge 7) then begin		; String or structure.
    hs_err_msg, '**** ERROR **** Variable must be numeric type.'
    return, -1
endif

s(t) = s(t) > 4
x = make_array(size=s)
pt = make_array(size=s, /byte)

if (s(t) ne 6) then locs = where(v gt 0) $
else		    locs = where(v ne complex(0.))

x(locs) = alog10(v(locs))
pt(locs) = x(locs) eq long(x(locs))

return, pt
end
