function norm_time, time

;+
; NORM_TIME
;	Convert a possibly unnormalized time array into a normalized
;	one.
;
; Usage:
;	time_array = norm_time(time)
;
; Return Value:
;	time_array	int	The normalized time.
;
; Argument:
;	time	int/fl	input	The time to be normalized in 
;					y, d, h, m, s form.
;
; History:
;	Original: 24/8/93; SJT
;	Removed integer restriction: 24/11/93; SJT
;	Fix for dates beyond 2000: 1/12/95; SJT
;-

time_array = time
ntt = n_elements(time_array)

locs = where(time_array ne 0, nv)
if (nv eq 1 and locs(0) eq 0) then time_array(1) = 1 ; Years start at day 1

if (time_array(0) mod 1. ne 0) then begin
    hs_err_msg, 'NORM_TIME: non-integer years forbidden'
    return, time_array
endif

shf = [24., 60., 60.]

for j = 1, 3 < (ntt-2) do begin
    time_array(j+1) = time_array(j+1) + (time_array(j) mod $
                                         1.)*shf(j-1)
    time_array(j) = float(long(time_array(j)))
endfor

if (ntt eq 5) then begin
    if (time_array(4) lt 0) then begin
	time_array(3) = time_array(3) + long(time_array(4))/60 - 1
	time_array(4) = (time_array(4) mod 60) + 60
    endif         
    if (time_array(4) ge 60) then begin
	time_array(3) = time_array(3) + long(time_array(4))/60
	time_array(4) = time_array(4) mod 60
    endif 
endif

if (ntt ge 4) then begin
    if (time_array(3) lt 0) then begin
        time_array(2) = time_array(2) + long(time_array(3))/60 - 1
        time_array(3) = (time_array(3) mod 60) + 60
    endif
    if (time_array(3) ge 60) then begin
        time_array(2) = time_array(2) + long(time_array(3))/60
        time_array(3) = time_array(3) mod 60
    endif 
endif

if (ntt ge 3) then begin
    if (time_array(2) lt 0) then begin
        time_array(1) = time_array(1) + long(time_array(2))/24 - 1
        time_array(2) = (time_array(2) mod 24) + 24
    endif
    if (time_array(2) ge 24) then begin
        time_array(1) = time_array(1) + long(time_array(2))/24
        time_array(2) = time_array(2) mod 24
    endif 
endif

length_check_y:					; Check day is not
						; beyond eoy

ily = 365 + (time_array(0) mod 4 eq 0)
ilyp = 365 + ((time_array(0)-1) mod 4 eq 0)
if (time_array(1) gt ily) then begin
    time_array(1) = time_array(1) - ily
    time_array(0) = time_array(0) + 1
    goto, length_check_y
endif else if (time_array(1) lt 0) then begin
    time_array(1) = time_array(1) + ilyp
    time_array(0) = time_array(0) - 1
    goto, length_check_y
endif 

time_array(0) = date100(time_array(0), /print)

return, time_array
end
