function monthhours, months, year

;+
; MONTHHOURS
;	Returns number of hours from start of year to end of given months.
;
; Usage:
;	hours = monthhours(months, year)
;
; Return Value:
;	hours	float	(Array) of number of hours to end of given months
;
; Arguments:
;	months	int	input	Numbers of months whose ends are needed.
;	year	int	input	The year for which the months are to be
;				calculated.
;
; Restrictions:
;	Will not work for century years not divisible by 400.
;
; History:
;	Original: 10/12/92; SJT
;-

lmonths = [31,28 + ((year mod 4) eq 0),31,30,31,30,31,31,30,31,30,31]
cmonths = intarr(13)
for i = 1, 12 do cmonths(i) = cmonths(i-1) + lmonths(i-1)

leap = (year mod 4) eq 0

hours = cmonths(months) * 24.

return, hours

end
