pro monitor, state, on=on, off=off

;+
; MONITOR
;	Controls whether compilation of routines is verified, and
;	also whether a message is output for each record read.
;	Simply sets the value of !QUIET.
;
; Usage:
;	monitor[, state]
;
; Argument:
;	state	int	input	0 for no information messages, 1 to print
;				them.
;
; Keywords:
;	on		If set and non-zero then switch monitoring on
;	off		If set and non-zero then switch monitoring off.
;
; Restrictions:
;	Only one value (key or argument) may be specified. 
;	If no values are given then the Current state is reversed.
;
; History:
;	Original: 4/9/91; SJT
;	Fix problem if !quiet explicitly 1 on entry: 7/1/92; SJT
;-

if ((nitem = n_params() + keyword_set(on) + keyword_set(off))) gt 1 then begin
    hs_err_msg, $
	'**** ERROR **** May only specify one or zero arguments and keys'
    return
endif

if (nitem eq 0) then            !quiet = (not !quiet) and 1 $
else if (n_params() eq 1) then  !quiet = (state eq 0) $
else if (keyword_set(on)) then  !quiet = 0 $
else if (keyword_set(off)) then !quiet = 1

end
