pro karv, rest=rest, age=age, level=level

;+
; KARV
;	Compute training heart rates using age-related Karvonen formula
;
; Usage:
;	karv[, rest=rest, age=age, level = level]
;
; Keywords:
;	rest	int	input	Your resting heart-rate. (bpm)
;	age	int	input	Your age in years.
;	level	int	input	The training level (or levels) for which you
;				want the rates (percent).
;
; History:
;	Original: 30/7/92; SJT
;-

if (not keyword_set(rest)) then begin
    r0 = 0
    read, 'Enter resting heart rate in bpm :_', r0
endif else r0 = rest

if (not keyword_set(age)) then begin
    y0 = 0
    read, 'Enter your age in years         :_', y0
endif else y0 = age

if (not keyword_set(level)) then begin
    l0 = 0
    read, 'Enter effort level required (%) :_', l0
endif else l0 = level

r1 = 220 - y0

dr = r1 - r0

for i = 0, n_elements(l0) - 1 do begin
    r = r0 + dr * l0(i) / 100.
    print, l0(i), r, $
	format="('At a ',i2,'% effort your heart rate is ',I3,'bpm')"
endfor

end
