pro invtan3d, x, y, z, th, ph

;+
;  INVTAN3D
;	Convert cartesian co-ordinates into directions.
;
;  Usage:
;	invtan, x, y, z, th, ph
;
;  Arguments:
;	x	float	input	X value(s).
;	y	float	input	Y value(s).
;	z	float	input	Z value(s).
;	th	float	output	Theta direction(s).
;	ph	float	output	Phi direction(s).
;
;  History:
;	Original: ????/92; Choo
;	Documented and tidied: 12/11/92; SJT
;
;  Restriction:
;	Returns degrees only.
;-

if (n_elements(x) gt 1) then begin
    ph = make_array(size=size(x))
    th = ph
endif else begin
    ph = 0.
    th = 0.
endelse

ii = where((y ne 0) or (x ne 0), cnt)
if cnt gt 0 then begin
    ph(ii) = atan(y,x) * !radeg
    ph = ph + (ph lt 0)*360
endif	

ii = where((z ne 0), cnt)
if cnt gt 0 then begin
    th(ii) = atan(sqrt(x^2 + y^2), z) * !radeg
    th = th + (th lt 0)*180
endif
end
