PRO hs_DispFile_evt, event

WIDGET_CONTROL, GET_UVALUE = retval, event.id

case retval of
    "EXIT": widget_control, event.top, /destroy
    
    "FIND": begin
        widget_control, event.id, get_value = txts
        txts = strlowcase(txts(0))
        sw = widget_info(event.id, /parent)
        widget_control, sw, get_uvalue = tw, /no_copy
        widget_control, tw.txt, get_value = text
        text = strlowcase(text)
        poss = strpos(text, txts)
        locs = where(poss ne -1)
        widget_control, tw.txt, set_text_top = (locs(0)-3) > 0
        tw.occ = 0
        widget_control, sw, set_uvalue = tw, /no_copy
    end
    "NEXT": begin
        sw = widget_info(event.id, /parent)
        widget_control, sw, get_uvalue = tw, /no_copy
        widget_control, tw.ss, get_value = txts
        txts = strlowcase(txts(0))
        widget_control, tw.txt, get_value = text
        text = strlowcase(text)
        poss = strpos(text, txts)
        locs = where(poss ne -1)
        tw.occ = tw.occ+1
        widget_control, tw.txt, set_text_top = $
          (locs(tw.occ mod n_elements(locs))-3) > 0
        widget_control, sw, set_uvalue = tw, /no_copy
    end
endcase

END


PRO hs_displayfile, FILE, TITLE=TITLE, GROUP=GROUP, WIDTH=WIDTH, $
                    HEIGHT=HEIGHT, TEXT=TEXT, FONT=font, bfont=bfont
;+
; HS_DISPLAYFILE
;	Display an ASCII text file using widgets and the widget manager.
;
; Usage:
;	HS_XDISPLAYFILE, File
;
; Argument:
;	File	string	input	A scalar string that contains the
;				filename of the file to display.  The
;				filename can include a path to that
;				file.
;
; Keywords:
;	FONT:   The name of the font to use.  If omitted use the default
;		font.
;	BFONT:  The name of the font to use for the control button(s).
;	GROUP:	The widget ID of the group leader of the widget.  If this 
;		keyword is specified, the death of the group leader results in
;		the death of XDISPLAYFILE.
;
;	HEIGHT:	The number of text lines that the widget should display at one
;		time.  If this keyword is not specified, 24 lines is the 
;		default.
;
;	TEXT:	A string or string array to be displayed in the widget
;		instead of the contents of a file.  This keyword overrides
;		the FILE input parameter.
;
;	TITLE:	A string to use as the widget title rather than the file name 
;		or "XDisplayFile".
;
;	WIDTH:	The number of characters wide the widget should be.  If this
;		keyword is not specified, 80 characters is the default.
;
; OUTPUTS:
;	No explicit outputs.  A file viewing widget is created.
;
; SIDE EFFECTS:
;	Triggers the XMANAGER if it is not already in use.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Open a file and create a widget to display its contents.
;
; History:
;	Modified from XDISPLAYFILE to add a search box: 27/6/95; SJT
;-

@wid_fonts

IF(NOT(KEYWORD_SET(TITLE))) THEN TITLE = FILE ;use the defaults if
IF(NOT(KEYWORD_SET(HEIGHT))) THEN HEIGHT = 24 ;the keywords were not
IF(NOT(KEYWORD_SET(WIDTH))) THEN WIDTH = 80 ;passed in

if (not keyword_set(font)) then font = normal_f
if (not keyword_set(bfont)) then bfont = normal_v

IF(NOT(KEYWORD_SET(TEXT)))THEN BEGIN
    OPENR, unit, FILE, /GET_LUN, ERROR = i ;open the file and then
    if i lt 0 then begin        ;OK?
        a = [ !Err_string, ' Can not display ' + file] ;No
    endif else begin
        maxlines = 1000
        a = strarr(maxlines)        ;Maximum # of lines
        i = 0
        c = ''
        while not eof(unit) do begin
            readf, unit, c
            a(i) = c
            i = i + 1
            if (i eq maxlines) then begin
                a = [temporary(a), strarr(100)]
                maxlines = maxlines+100
            endif
        endwhile
        a = a(0:(i-1) > 0)      ;Added empty file check -KDB
        FREE_LUN, unit          ;free the file unit.
    endelse
ENDIF ELSE a = TEXT

filebase = WIDGET_BASE(TITLE = TITLE, $ ;create the base
                       /COLUMN, $
                       SPACE = 20, $
                       XPAD = 20, $
                       YPAD = 20)

filequit = WIDGET_BUTTON(filebase, $ ;create a Done Button
                         VALUE = "Done with " + TITLE, $
                         UVALUE = "EXIT", font = bfont)

filetext = WIDGET_TEXT(filebase, $ ;create a text widget
                       XSIZE = WIDTH, $ ;to display the file's
                       YSIZE = HEIGHT, $ ;contents
                       /SCROLL, FONT = font, $
                       VALUE = a)

jb = widget_base(filebase, /row)
junk = widget_label(jb, value = 'Search for:', font = bfont)
sstring = widget_text(jb, ysize = 1, xsize = width-20, /edit, /frame, $
                      font = font, uvalue = 'FIND')
next = widget_button(jb, value = 'Next', uvalue = 'NEXT', font = $
                     bfont)
widget_control, jb, set_uvalue = {txt:filetext, occ:0, ss:sstring}


WIDGET_CONTROL, filebase, /REALIZE ;instantiate the widget

Xmanager, "XDisplayFile", $     ;register it with the
  filebase, $                   ;widget manager
  GROUP_LEADER = GROUP, $
  EVENT_HANDLER = "hs_DispFile_evt" 

END
;--------------------- procedure XDisplayFile ----------------------------
