;+
; EDIT_MENU
;	Widget interface to editor
;
; Usage:
;	edit_menu
;
; Arguments: None
;
; Keywords:
;	group	long	input	Group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly.
;
; History:
;	Original: 22/1/93; SJT
;	Added group keyword: 22/1/93; SJT
;	Remove output file as an irrelevance + allow char cell mode:
;					1/2/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;	Force scrolling if the base is too big: 21/4/94; SJT
;-

pro edit_event, event

;	Event handler

@edit_wid

widget_control, event.id, get_uvalue=but

case but of

;	Exits

    'CANCEL': begin
	widget_control, event.top, /destroy
	return
    end

    'DO': begin
;		Note re-read the file in case no return after editing

	widget_control, selfile, get_value=txt
	sfname = txt(0)

	widget_control, event.top, /destroy
	edit, sfname, start=istart, font=fsiz, xinter=x_ed_mode
	return
    end

;	Directories

    'CUR': begin
	cd, current=currdir
	widget_control, dirtxt, set_value=currdir
	sfdir = currdir
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
	widget_control, filttxt, /input_focus
    end

    'NULL': begin
	widget_control, dirtxt, set_value=''
	sfdir = ''
	flist = ['']
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
	widget_control, dirtxt, /input_focus
    end

    'DIR': begin
	widget_control, dirtxt, get_value=txt
	sfdir = txt(0)
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
	widget_control, filttxt, /input_focus
    end

;	The filename filter

    'FILT': begin
	widget_control, filttxt, get_value = txt
	sffilt = txt(0)
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
	widget_control, dirtxt, /input_focus
    end

;	Setting the filename

    'SELECT': begin
	sfname = flist(event.index)
	widget_control, selfile, set_value=sfname
	ido = 1
	widget_control, selfile, /input_focus
    end

    'FILE': begin
	widget_control, selfile, get_value=txt
	sfname = txt(0)
	ido = 1
    end

;	Initial line number

    'SLINE': begin
	widget_control, lntxt, get_value=txt
	if (max(strlen(txt)) ne 0) then reads, txt, istart $
	else widget_control, lntxt, set_value=string(istart)
    end

;	Interface mode

    'X-CHAR': begin
	x_ed_mode = event.select
	if (!version.os ne 'vms') then widget_control, fntbase, $
			sensitive=x_ed_mode
    end

;	Anything else must be a font size

    else: fsiz = but
endcase

widget_control, dobut, sensitive = ido

end

pro edit_menu, group=group

;	Menu maker

@edit_wid
@wid_fonts
@wid_set

if (xregistered('edit')) then return	; Don't make a second copy.

;	input file things

dirch = ['Current', 'Null', 'Apply']
udirc = ['CUR', 'NULL', 'DIR']
istart = 1
ido = 0

cd, current= currdir
if (n_elements(sfdir) eq 0) then sfdir = currdir

if (!version.os eq 'vms') then sffilt = '*.*' $
else			     sffilt = '*'

;	font sizes & mode

fonts = ['Tiny', 'Small', 'Normal', 'Large', 'Huge']
ufonts = ['100', '120', '140', '180', '240']
if (n_elements(fsiz) eq 0) then fsiz = '140'
if (n_elements(x_ed_mode) eq 0) then x_ed_mode = 1

;	Check availability of xemacs

if (!version.os ne 'vms') then begin
    spawn, /sh, 'which xemacs', xem
    if (strpos(xem(0),'no xemacs in') eq -1) then xok = 1 $
    else				       xok = 0
endif else xok = 1

;	Base widgets

iscroll = 0

Make_menu:

if (iscroll) then base = widget_base(title = 'EDITOR', xpad = 5, ypad $
                                     = 5, /column, $
                                     /scroll, x_scroll_size = xss, $
                                     y_scroll_size = yss) $
else base = widget_base(title = 'EDITOR', xpad = 5, ypad = 5, /column)

txt = widget_label(base, value = 'Invoke Editor', frame = 2, font = large_v)

;	The file name

inbase = widget_base(base, /column, /frame)
junk = widget_label(inbase, value='Input file selection', font=normal_v)

jb = widget_base(inbase, /column)
dirbase = widget_base(/row, /frame, jb)
dirlab = widget_label(dirbase, val='Directory', font=normal_v)
jb1 = widget_base(dirbase, /column)
dirtxt = widget_text (/edit, jb1,  value=sfdir, uval='DIR', $
	xsize=40, ysize=1, /frame, font=normal_f)
xmenu, dirch, jb1, uvalue = udirc, /row, font = normal_v

filtbase = widget_base(/row, /frame, inbase)
filtlab = widget_label(filtbase, val='Filter', font=normal_v)
filttxt = widget_text(/edit, filtbase, value=sffilt, uval='FILT', $
	xsize=40, ysize=1, /frame, font=normal_f)
junk = widget_button(filtbase, value='Apply', uval='FILT', font=normal_v)

selbase = widget_base(/column, /frame, inbase)
sellab = widget_label(selbase, val='File Selection Menu', font=normal_v)
sp = form_fname(sffilt, sfdir)
flist = findfile(sp)
selmenu = widget_list(selbase, val=flist, uval='SELECT', $
	ysize=6, /frame, font=normal_f)

sfname =''
sellab2 = widget_label(selbase, val='File to edit:', font=normal_v)
selfile = widget_text(selbase, /frame, val=sfname, xsize=50, ysize=1, $
	/edit, uvalue='FILE', font=normal_f)

;	Starting line

lnbase = widget_base(selbase, /row, /frame)
junk = widget_label(lnbase, value='Start line: ', font=normal_v)
lntxt = widget_text(lnbase, xsize=10, ysize=1, /edit, /frame, $
	value=string(istart), uvalue='SLINE', font=normal_f)
junk = widget_button(lnbase, value='Apply', uvalue='SLINE', font=normal_v)

if (xok) then begin
;	X / Char cell mode.

    jb = widget_base(base, /row)
    junk = widget_label(jb, value = 'X or Character Cell Interface?', $
		font=normal_v)
    jb1 = cw_tbutton(jb, value = ['Character Cell', 'X Interface'], $
                     uvalue = 'X-CHAR', state = x_ed_mode, font = $
                     normal_v)

;	Font sizes - unix only

    if (!version.os ne 'vms') then begin
        fntbase = widget_base(base, /column, /frame)
        junk = widget_label(fntbase, value='Font Selection', font=normal_v)
        xmenu, fonts, fntbase, /row, /exclusive, $
	    uvalue=ufonts, /no_release, button=bid, font=normal_v
        ifs = (where(ufonts eq fsiz))(0)
        widget_control, bid(ifs), /set_button
        widget_control, fntbase, sensitive=x_ed_mode
    endif
endif

;	Exit buttons

jb = widget_base(base, /row)
canbut = widget_button(jb, value='Cancel', uvalue='CANCEL', font=normal_v)
dobut = widget_button(jb, value='Do it', uvalue='DO', font=normal_v)
widget_control, dobut, sensitive = 0

;	realize

widget_control, base, /real, tlb_get_size = wid_size

if (wid_size(0) gt 0.9*screen_size(0) or wid_size(1) gt $
    0.9*screen_size(1) and not iscroll) then begin
    widget_control, base, /destroy
    iscroll = 1
    xss = screen_size(0)*0.9 < (wid_size(0) + 40)
    yss = screen_size(1)*0.9 < (wid_size(1) + 40)
    goto, make_menu
endif

widget_control, dirtxt, /input_focus
xmanager, 'edit', base, group=group

end
