pro edit, infil, start=start, font=font, xinterface=xinterface

;+
; EDIT
;	Interface to an editor.
;
; Usage:
;	edit, infil[, start=start, font=font, /xinterface]
;
; Arguments:
;	infil	string	input	The file to edit
;
; Keywords:
;	start	int	input	The line number at which to start.
;	xinterface	input	If set and non-zero, use the X-interface
;	font	string	input	The fontsize (one of 100,120,140,180,240)
;				Only applicable to Unix X interface 
;				Ignored for any other cases.
;
; Action:
;	This routine invokes the shareable version of the TPU editor on
;	VMS and spawns the `emacs' editor on Unix.
;
; Restrictions:
;	This routine was developed with the GNU emacs in mind so it is
;	not certain to work for other versions. Also it is assumed that
;	the command `emacs' invokes the character cell interface and 
;	`xemacs' the X interface.
;
; History:
;	Original (using code from the EVE routine): 22/1/93; SJT
;	Remove output file (nuisence), add xinterface key: 1/2/93; SJT
;	Check availability of commands with cascade to vi (unix): 10/9/93; SJT
;-

case n_params() of
    0:	begin
        filei = ''
        read, 'File to edit :_', filei
    end
    1:  begin
	filei = infil
    end
endcase

if (!version.os eq 'vms') then begin

;		For VMS invoke the TPU editor in its shareable form
;		options are appended to the input filename.

    if (keyword_set(xinterface)) then filei = filei+'/interface=decwindows'
    if keyword_set(start) then $
		filei = strcompress(filei+'/start='+string(start), /remove)

    stat = call_external ('TPUSHR', 'TPU$EDIT', filei, '')

endif else begin

;		For Unix invoke the emacs editor by spawning

    if (keyword_set(xinterface)) then begin
        spawn, /sh, 'which xemacs', xem
        if (strpos(xem(0),'no xemacs in') eq -1) then begin
	    cmd = 'xemacs '
           if (keyword_set(font)) then cmd = cmd + $
		'-fn \*courier-medium-r-\*-' + font + '-\* '
        endif else begin
	    hs_err_msg, "xemacs is not available, using emacs."
	    cmd = 'emacs'
	endelse
    endif else cmd = 'emacs '

;		Check that emacs is available, if not then use vi.

    if (cmd eq 'emacs') then begin
        spawn, /sh, 'which emacs', xem
	if (strpos(xem(0),'no emacs in') ne -1) then begin
	    hs_err_msg, "emacs is not available, using vi"
	    cmd = 'vi '
	endif
    endif

    if (keyword_set(start)) then cmd = cmd + $
		strcompress('+'+string(start), /remove)

    cmd = cmd + ' ' + filei

    spawn, cmd
endelse

end

