function Date100, year, print=print, full=full

;+
; DATE100
;	Return a "mod 100" year in the range 50 to 150
;
; Usage:
;	y100 = date100(year[, /print])
;
; Return:
;	y100	<input>	The fixed year value
;
; Argument:
;	year	any	input	The year to be normalized
;
; Keywords:
;	print	???	input	If set, then return a true mod 100
;				value suitable for printing.
;	Full	???	input	If set, then convert to a full year
;				with century
;
; History:
;	Original: 1/12/95; SJT
;-

if (keyword_set(print)) then return, year mod 100 $
else if (keyword_set(full)) then return, ((year + 50) mod 100) + 1950 $
else return, ((year + 50) mod 100) + 50

end
