;+
; CW_TOGGLE
;	A compound widget to make a menu of toggle pairs.
;
; Usage:
;	wid = cw_toggle(base, names)
;
; Return value:
;	wid	long	Widget ID of the generated top-level widget
;
; Arguments:
;	base	long	input	The base widget to be the parent of
;				the menu.
;	names	string	input	a (2,n) array of the toggle names, or
;				a 1-d array if the off_on key is set
;
; Keywords: 
;	column		int	Number of columns to use for the toggles
;	event_funct	string	Event handler function.
;	font		string	Font for the menus
;	frame		?	If set put a frame around the whole
;				menu
;	bids		long	(output) Contains the widget IDS of
;				the individual buttons in the menus
;	mids		long	(output) Contains the widget IDS of
;				the toggle bases
;	map			If set to zero don't map the toggle
;				set.
;	return_id		If set, then return the toggle-base id
;				in the event structure value field.
;	return_index		If set, then return the toggle-base
;				index (this is the default unless
;				uvalues are give).
;	row		int	Number of rows to use for the toggles.
;	scroll			If set, the create a scrolling base
;	uvalue		???	Uvalue to be returned from a
;				GET_UVALUE on the top-level base
;	xoffset		int	X-Offset in base
;	yoffset		int	Y-Offset in base
;	xsize,ysize	int	X & Y sizes of the menu
;	x_scroll_size,	int	X & Y sizes of the scrolling region 
;	y_scroll_size
;	xpad,ypad	int	Space around base.
;	space		int	Padding between toggles
;	t_column		If set arrange the two buttons of each
;				toggle one above the other
;	t_row			If set, arrange the two buttons of
;				each toggle side by side.
;	t_frame			If set put a frame round each toggle.
;	t_uvalue	??	Set a UVALUE for each toggle.
;	t_state		byte	Array of initial states for the
;				toggles.
;	off_on			If set, then the input button list is
;				a 1-d array an the elements are
;				duplicated with off and on appended.
;
; History:
;	Original (derived from CW_BGROUP): 25/10/94; SJT
;-

pro Cw_toggle_setv, id, value

ON_ERROR, 2                     ;return to caller

stash = WIDGET_INFO(id, /CHILD)
WIDGET_CONTROL, stash, GET_UVALUE = state

n = n_elements(state.mids)
if (n_elements(value) ne n) then message, 'Must give one value per ' + $
  'toggle'

for j = 0, n-1 do widget_control, state.bids(value(j), j), /set_button

state.toggle = value

WIDGET_CONTROL, stash, SET_UVALUE = state

end



function CW_TOGGLE_GETV, id, value

ON_ERROR, 2                     ;return to caller

stash = WIDGET_INFO(id, /CHILD)
WIDGET_CONTROL, stash, GET_UVALUE = state

ret = state.toggle

return, ret

end



function CW_TOGGLE_EVENT, ev

base = ev.handler
stash = WIDGET_INFO(base, /CHILD)
WIDGET_CONTROL, stash, GET_UVALUE = state
WIDGET_CONTROL, ev.id, get_uvalue = uvalue

if (ev.select eq 0) then return, 0

itoggle = uvalue(0)
istate = uvalue(1)

state.toggle(itoggle) = istate

ret = { ID:base, TOP:ev.top, HANDLER:0L, SELECT:istate, $
        Value:state.ret_arr(itoggle) }
efun = state.efun

WIDGET_CONTROL, stash, SET_UVALUE = state

if efun ne '' then return, CALL_FUNCTION(efun, ret) $
else return, ret

end







function Cw_toggle, parent, names, $
                    COLUMN=column, EVENT_FUNCT=efun, FONT=font, $
                    FRAME=frame, BIDS=bids, MIDS=mids, MAP=map, $
                    RETURN_ID=return_id, RETURN_INDEX=return_index, $
                    ROW=row, SCROLL=scroll, $
                    SPACE=space, UVALUE=uvalue, $ 
                    XOFFSET=xoffset, XPAD=xpad, XSIZE=xsize, $
                    X_SCROLL_SIZE=x_scroll_size, YOFFSET=yoffset, $
                    YPAD=ypad, YSIZE=ysize, $
                    Y_SCROLL_SIZE=y_scroll_size, t_column=t_column, $
                    t_row=t_row, t_frame=t_frame, t_uvalue=t_uvalue, $
                    t_state=t_state, off_on=off_on

IF (N_PARAMS() ne 2) THEN MESSAGE, 'Incorrect number of arguments'

ON_ERROR, 2                     ;return to caller

                                ; Set default values for the keywords
  
version = WIDGET_INFO(/version)
if (version.toolkit eq 'OLIT') then def_space_pad = 4 else def_space_pad = 3
IF (N_ELEMENTS(column) eq 0) 		then column = 0
IF (N_ELEMENTS(frame) eq 0)		then frame = 0
IF (N_ELEMENTS(map) eq 0)		then map = 1
IF (N_ELEMENTS(row) eq 0)		then row = 0
IF (N_ELEMENTS(scroll) eq 0)		then scroll = 0
IF (N_ELEMENTS(space) eq 0)		then space = def_space_pad
IF (N_ELEMENTS(uvalue) eq 0)		then uvalue = 0
IF (N_ELEMENTS(xoffset) eq 0)		then xoffset = 0
IF (N_ELEMENTS(xpad) eq 0)		then xpad = def_space_pad
IF (N_ELEMENTS(xsize) eq 0)		then xsize = 0
IF (N_ELEMENTS(x_scroll_size) eq 0)	then x_scroll_size = 0
IF (N_ELEMENTS(yoffset) eq 0)		then yoffset = 0
IF (N_ELEMENTS(ypad) eq 0)		then ypad = def_space_pad
IF (N_ELEMENTS(ysize) eq 0)		then ysize = 0
IF (N_ELEMENTS(y_scroll_size) eq 0)	then y_scroll_size = 0
if (n_elements(t_column) eq 0)		then t_column = 0
if (n_elements(t_row) eq 0)		then t_row = 0
if (n_elements(t_frame) eq 0) 		then t_frame = 0

top_base = 0L

                                ; We need some kind of outer base to
                                ; hold the users UVALUE 
top_base = WIDGET_BASE(parent, XOFFSET = xoffset, YOFFSET = yoffset)
next_base = top_base

                                ; Set top level base attributes
WIDGET_CONTROL, top_base, MAP = map, EVENT_FUNC = 'CW_TOGGLE_EVENT', $
  FUNC_GET_VALUE = 'CW_TOGGLE_GETV', PRO_SET_VALUE = 'CW_TOGGLE_SETV', $
  SET_UVALUE = uvalue

                                ; The toggle holding base
base = WIDGET_BASE(next_base, COLUMN = column, FRAME = frame, ROW = $
                   row, SCROLL = scroll, SPACE = space, XPAD = xpad, $
                   XSIZE = xsize, X_SCROLL_SIZE = x_scroll_size, YPAD $
                   = ypad, YSIZE = ysize, Y_SCROLL_SIZE = y_scroll_size)


if (keyword_set(off_on)) then begin
    bnames = names(indgen(2, n_elements(names))/2)
    bnames(0, *) = bnames(0, *)+' Off'
    bnames(1, *) = bnames(1, *)+' On'
endif else bnames = names
n = n_elements(bnames(0, *))

mids = lonarr(n)
bids = lonarr(2, n)
if (n_elements(t_uvalue) eq 0) then t_uvalue = indgen(n)
if (n_elements(t_state) eq 0) then lt_state = bytarr(n) $
else if (n_elements(t_state) eq 1) then lt_state = replicate(t_state, 1) $
else lt_state = t_state

for i = 0, n-1 do begin
    mids(i) = widget_base(base, column = t_column, row = t_row, $
                          /exclusive, frame = t_frame, uvalue = $
                          t_uvalue(i))
    for j = 0, 1 do begin
        if (n_elements(font) eq 0) then begin
            bids(j, i) = WIDGET_BUTTON(mids(i), value = bnames(j, i), $
                                       UVALUE = [i, j])
        endif else begin
            bids(j, i) = WIDGET_BUTTON(mids(i), value = bnames(j, i), $
                                       UVALUE = [i, j], font = font)
        endelse
    endfor
    
                                ; Set the initial state here as it
                                ; must always be set
    
    widget_control, /set_button, bids(lt_state(i), i)
endfor

; Keep the state info in the real (inner) base UVALUE.
; Pick an event value type:
;	0 - Return Toggle ID
;	1 - Return Button ID
;	2 - Return INDEX
;	3 - Return NAME
;	4 - Return Toggle Uvalue

ret_type = 1
if KEYWORD_SET(RETURN_ID) then ret_type = 0
if KEYWORD_SET(T_UVALUE) then ret_type = 2
case ret_type of
    0: ret_arr = mids
    1: ret_arr = indgen(n)
    2: ret_arr = t_uvalue
endcase

is_motif = version.style eq 'Motif'

if n_elements(efun) le 0 then efun = ''

state = {   Ret_arr:ret_arr, $  ; Vector of event values
            Efun: efun, $	; Name of event fcn
            Mids:mids, $        ; Ids of toggle bases
            Bids:bids, $        ; Ids of buttons
            Toggle:lt_state, $  ; Current setting
            Is_motif:is_motif } ; TRUE if Motif widgets

WIDGET_CONTROL, WIDGET_INFO(top_base, /CHILD), SET_UVALUE = state

return, top_base

END
