function Cv3to2, x

;+
; CV3TO2
;	Convert 3-D data coords to 2d normalized coords, also
;	returning the Z coordinate.
;
; Usage:
;	x2n = cv3to2(x)
;
; Return value:
;	x2n	float	3 element vector the 2-d normalized position
;			and the Z-value.
;
; Argument:
;	x	float	input	The 3-d position vector to be
;				converted.
;
; History:
;	Original (after IDL manual): 7/4/95; SJT
;-

p = [[!X.s(0) + !X.s(1)*(x(0, *))(*)], $
     [!Y.s(0) + !Y.s(1)*(x(1, *))(*)], $
     [!Z.s(0) + !Z.s(1)*(x(2, *))(*)], $
     [replicate(1.0, n_elements(x(0, *)))]]

p = transpose(p#!P.t)

return, p(0:2, *)/p([3, 3, 3], *)

end
