function Calstr, jd, mdy=mdy

;+
; CALSTR
;	Return data of a give JD number as a string
;
; Usage:
;	date = calstr(jd)
;
; Return:
;	date	string	Date in format dd-mmm-yyyy[BC]
;			(mmm-dd-yyyy[BC] if mdy set)
;
; Argument:
;	jd	(long)	input	the Julian day to convert.
;
; Keyword:
;	mdy	if set give the date in US (mdy) format rather than
;		European (dmy) form
;
; History:
;	Original: 14/7/95; SJT
;-

caldat, jd, m, d, y

mon = (['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',  $
        'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'])(m-1)

if (y le 0) then year = string(abs(y)+1, format = "(I4,'BC')") $
else year = string(y, format = "(I4)")

day = string(d, format = "(I2.2)")

if (keyword_set(mdy)) then return, mon+'-'+day+'-'+year $
else return, day+'-'+mon+'-'+year

end
