pro Wid_font_init, small=small

;+
; WID_FONT_INIT
;	Define widget fonts.
;
; Usage:
;	wid_font_init
;
; Arguments: none
;
; Keywords:
;	small	?	input	If set, then use the small fonts
;				regardless of the HS_SMALL_FONTS
;				setting.
;
; History:
;	Original (extracted from HS_MENU_TOP): 17/2/95; SJT
;-

@wid_fonts

;		Initialize font definitions

if (keyword_set(small)) then sf = 'YES' $
else sf = getenv("HS_SMALL_FONTS")

if (sf eq '' or strupcase(sf) eq 'NO') then begin
    tiny_v = '*helvetica-medium-r-*-100-*'
    small_v = '*helvetica-medium-r-*-120-*'
    normal_v = '*helvetica-medium-r-*-140-*'
    large_v = '*helvetica-bold-r-*-180-*'

    tiny_f = '*courier-medium-r-*-100-*'
    small_f = '*courier-medium-r-*-120-*'
    normal_f = '*courier-medium-r-*-140-*'
endif else begin
    tiny_v = '*helvetica-medium-r-*-80-*'
    small_v = '*helvetica-medium-r-*-100-*'
    normal_v = '*helvetica-medium-r-*-120-*'
    large_v = '*helvetica-bold-r-*-140-*'

    tiny_f = '*courier-medium-r-*-80-*'
    small_f = '*courier-medium-r-*-100-*'
    normal_f = '*courier-medium-r-*-120-*'
endelse

end
