;+
; VERSION_MM
;	widget interface for the version mismatch action.
;
; Usage:
;	action = version_mm(message[, /notruncate])
;
; Return Value:
;	action	string	one of 'A' (abort), 'T' (truncate), 'C' (continue)
;
; Argument:
;	message	string	input	A message text to say what is wrong.
;
; Keyword:
;	notruncate	If set and non-zero don't allow the truncate
;	option. 
;
; History:
;	Original: 2/2/93; SJT
;	Add font control: 3/11/93; SJT
;	Add notruncate keyowrd to omit truncate option: 23/5/95; SJT
;-

pro vers_event, event

;	The event handler, is very simple as the uvalues are the
;	required return values and only one press is needed.

@vers_wid

widget_control, event.id, get_uvalue=action
widget_control, event.top, /destroy
widget_control, /hourglass
end

function version_mm, message, notruncate=notruncate

;	The menu maker

@vers_wid
@wid_set
@wid_fonts

if (keyword_set(notruncate)) then begin
    opts = ['Continue', 'Abort']
    uopt = ['C', 'A']
    ts = ''
endif else begin
    opts = ['Continue', 'Truncate', 'Abort']
    uopt = ['C', 'T', 'A']
    ts = 'Truncate (T), '
endelse

if (not wid_mode) then begin
    print, message, format="(A)"

    action = ''
action:
    read, 'Action to take, Abort (A), '+ts+'Continue (C) <C> :_', $
			action

    action = strupcase(action)
    if (action eq '') then action='C'
    if ((where(action eq uopt))(0) eq -1) then goto, action

endif else begin

    base = widget_base(title='Version Mismatch', xpad=5, ypad=5, $
	/column)
    junk = widget_label(base, value='Version Mismatch Action', /frame, $
		font=large_v)

    junk=widget_text(base, value=message, xsize=max(strlen(message)), $
	ysize=n_elements(message), font=normal_f)

    xmenu, opts, base, /row, uvalue=uopt, font=normal_v

    widget_control, base, /real
    xmanager, 'vers', base, /modal		; Must be /modal to prevent
						; premature return
endelse

return, action

end

